/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.server.AbstractPathMapping;
import karate.com.linecorp.armeria.server.PathMapping;
import karate.com.linecorp.armeria.server.RegexPathMappingWithPrefix;
import karate.com.linecorp.armeria.server.RoutePathType;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingResult;
import karate.com.linecorp.armeria.server.RoutingResultBuilder;

final class RegexPathMapping
extends AbstractPathMapping {
    private static final Pattern NAMED_GROUP_PATTERN = Pattern.compile("\\(\\?<([^>]+)>");
    private final Pattern regex;
    private final Set<String> paramNames;
    private final String pathPattern;
    private final String strVal;
    private final List<String> paths;

    RegexPathMapping(Pattern regex) {
        this.regex = Objects.requireNonNull(regex, "regex");
        this.paramNames = RegexPathMapping.findParamNames(regex);
        this.pathPattern = regex.pattern();
        this.strVal = "regex:" + this.pathPattern;
        this.paths = ImmutableList.of(regex.pattern());
    }

    private static Set<String> findParamNames(Pattern regex) {
        Matcher matcher = NAMED_GROUP_PATTERN.matcher(regex.pattern());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int pos = 0;
        while (matcher.find(pos)) {
            builder.add(matcher.group(1));
            pos = matcher.end();
        }
        return builder.build();
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new RegexPathMappingWithPrefix(prefix, this);
    }

    @Override
    @Nullable
    protected RoutingResultBuilder doApply(RoutingContext routingCtx) {
        Matcher matcher = this.regex.matcher(routingCtx.path());
        if (!matcher.find()) {
            return null;
        }
        RoutingResultBuilder builder = RoutingResult.builderWithExpectedNumParams(this.paramNames.size()).path(routingCtx.path()).query(routingCtx.query());
        for (String name : this.paramNames) {
            String value = matcher.group(name);
            if (value == null) continue;
            builder.rawParam(name, value);
        }
        return builder;
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String patternString() {
        return this.pathPattern;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.REGEX;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.regex.pattern().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof RegexPathMapping && (this == obj || this.regex.pattern().equals(((RegexPathMapping)obj).regex.pattern()));
    }

    @Override
    public String toString() {
        return this.strVal;
    }
}

