/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.AbstractPathMapping;
import karate.com.linecorp.armeria.server.PathMapping;
import karate.com.linecorp.armeria.server.RoutePathType;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingResultBuilder;

final class RegexPathMappingWithPrefix
extends AbstractPathMapping {
    private final String pathPrefix;
    private final PathMapping mapping;
    private final String pathPattern;
    private final List<String> regexAndPrefix;

    RegexPathMappingWithPrefix(String pathPrefix, PathMapping mapping) {
        Objects.requireNonNull(mapping, "mapping");
        assert (mapping.pathType() == RoutePathType.REGEX) : "unexpected mapping type: " + mapping.getClass().getName();
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        this.mapping = mapping;
        this.regexAndPrefix = ImmutableList.of(mapping.paths().get(0), pathPrefix);
        String patternString = mapping.patternString();
        String normalizedPathPrefix = pathPrefix.endsWith("/") && patternString.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) : pathPrefix;
        this.pathPattern = normalizedPathPrefix + patternString;
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new RegexPathMappingWithPrefix(ArmeriaHttpUtil.concatPaths(prefix, this.pathPrefix), this.mapping);
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        String path = routingCtx.path();
        if (!path.startsWith(this.pathPrefix)) {
            return null;
        }
        return this.mapping.apply(routingCtx.withPath(path.substring(this.pathPrefix.length() - 1)));
    }

    @Override
    public Set<String> paramNames() {
        return this.mapping.paramNames();
    }

    @Override
    public String patternString() {
        return this.pathPattern;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.REGEX_WITH_PREFIX;
    }

    @Override
    public List<String> paths() {
        return this.regexAndPrefix;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexPathMappingWithPrefix)) {
            return false;
        }
        RegexPathMappingWithPrefix that = (RegexPathMappingWithPrefix)o;
        return this.pathPrefix.equals(that.pathPrefix) && this.mapping.equals(that.mapping);
    }

    public int hashCode() {
        return 31 * this.pathPrefix.hashCode() + this.mapping.hashCode();
    }

    @Override
    public String toString() {
        return "[prefix:" + this.pathPrefix + ", " + this.mapping + ']';
    }
}

