/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.QueryParams;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.server.RouteUtil;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import karate.com.linecorp.armeria.server.CatchAllPathMapping;
import karate.com.linecorp.armeria.server.DefaultRoute;
import karate.com.linecorp.armeria.server.ExactPathMapping;
import karate.com.linecorp.armeria.server.GlobPathMapping;
import karate.com.linecorp.armeria.server.HttpHeaderUtil;
import karate.com.linecorp.armeria.server.ParameterizedPathMapping;
import karate.com.linecorp.armeria.server.PathMapping;
import karate.com.linecorp.armeria.server.PrefixPathMapping;
import karate.com.linecorp.armeria.server.RegexPathMapping;
import karate.com.linecorp.armeria.server.RegexPathMappingWithPrefix;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.RoutingPredicate;

public final class RouteBuilder {
    static final Route CATCH_ALL_ROUTE = new RouteBuilder().catchAll().build();
    static final Route FALLBACK_ROUTE = new RouteBuilder().fallback(true).catchAll().build();
    @Nullable
    private PathMapping pathMapping;
    private Set<HttpMethod> methods = ImmutableSet.of();
    private Set<MediaType> consumes = ImmutableSet.of();
    private Set<MediaType> produces = ImmutableSet.of();
    private final List<RoutingPredicate<QueryParams>> paramPredicates = new ArrayList<RoutingPredicate<QueryParams>>();
    private final List<RoutingPredicate<HttpHeaders>> headerPredicates = new ArrayList<RoutingPredicate<HttpHeaders>>();
    private boolean isFallback;
    private final List<Route> excludedRoutes = new ArrayList<Route>();

    RouteBuilder() {
    }

    public RouteBuilder path(String pathPattern) {
        return this.pathMapping(RouteBuilder.getPathMapping(pathPattern));
    }

    public RouteBuilder path(String prefix, String pathPattern) {
        prefix = RouteUtil.ensureAbsolutePath(prefix, "prefix");
        if (pathPattern.isEmpty()) {
            return this.path(prefix);
        }
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        if ("/".equals(prefix)) {
            return this.path(pathPattern);
        }
        if (pathPattern.startsWith("/")) {
            return this.path(ArmeriaHttpUtil.concatPaths(prefix, pathPattern));
        }
        if (pathPattern.startsWith("exact:")) {
            return this.exact(ArmeriaHttpUtil.concatPaths(prefix, pathPattern.substring("exact:".length())));
        }
        if (pathPattern.startsWith("prefix:")) {
            return this.pathPrefix(ArmeriaHttpUtil.concatPaths(prefix, pathPattern.substring("prefix:".length())));
        }
        if (pathPattern.startsWith("glob:")) {
            String glob = pathPattern.substring("glob:".length());
            return this.pathMapping(RouteBuilder.globPathMapping(prefix, glob, 0));
        }
        return this.pathMapping(new RegexPathMappingWithPrefix(prefix, RouteBuilder.getPathMapping(pathPattern)));
    }

    private static PathMapping globPathMapping(String prefix, String glob, int numGroupsToSkip) {
        if (glob.startsWith("/")) {
            return RouteBuilder.globPathMapping(ArmeriaHttpUtil.concatPaths(prefix, glob), numGroupsToSkip);
        }
        return RouteBuilder.globPathMapping(ArmeriaHttpUtil.concatPaths(prefix + "**/", glob), numGroupsToSkip + 1);
    }

    private static PathMapping globPathMapping(String glob, int numGroupsToSkip) {
        if (glob.startsWith("/") && !glob.contains("*")) {
            return new ExactPathMapping(glob);
        }
        return new GlobPathMapping(glob, numGroupsToSkip);
    }

    RouteBuilder pathMapping(PathMapping pathMapping) {
        this.pathMapping = pathMapping;
        return this;
    }

    public RouteBuilder exact(String exactPath) {
        return this.pathMapping(new ExactPathMapping(Objects.requireNonNull(exactPath, "exactPath")));
    }

    public RouteBuilder pathPrefix(String prefix) {
        return this.pathPrefix(prefix, true);
    }

    public RouteBuilder pathPrefix(String prefix, boolean stripPrefix) {
        return this.pathMapping(RouteBuilder.prefixPathMapping(Objects.requireNonNull(prefix, "prefix"), stripPrefix));
    }

    public RouteBuilder catchAll() {
        return this.pathMapping(CatchAllPathMapping.INSTANCE);
    }

    public RouteBuilder glob(String glob) {
        return this.glob(glob, 0);
    }

    private RouteBuilder glob(String glob, int numGroupsToSkip) {
        Objects.requireNonNull(glob, "glob");
        return this.pathMapping(RouteBuilder.globPathMapping(glob, numGroupsToSkip));
    }

    public RouteBuilder regex(String regex) {
        return this.regex(Pattern.compile(Objects.requireNonNull(regex, "regex")));
    }

    public RouteBuilder regex(Pattern regex) {
        return this.pathMapping(new RegexPathMapping(regex));
    }

    public RouteBuilder methods(HttpMethod ... methods) {
        this.methods(ImmutableSet.copyOf(Objects.requireNonNull(methods, "methods")));
        return this;
    }

    public RouteBuilder methods(Iterable<HttpMethod> methods) {
        this.methods = Sets.immutableEnumSet(Objects.requireNonNull(methods, "methods"));
        return this;
    }

    public RouteBuilder consumes(MediaType ... consumeTypes) {
        this.consumes(ImmutableSet.copyOf(Objects.requireNonNull(consumeTypes, "consumeTypes")));
        return this;
    }

    public RouteBuilder consumes(Iterable<MediaType> consumeTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(consumeTypes, "consumeTypes");
        this.consumes = ImmutableSet.copyOf(consumeTypes);
        return this;
    }

    public RouteBuilder produces(MediaType ... produceTypes) {
        this.produces(ImmutableSet.copyOf(Objects.requireNonNull(produceTypes, "produceTypes")));
        return this;
    }

    public RouteBuilder produces(Iterable<MediaType> produceTypes) {
        HttpHeaderUtil.ensureUniqueMediaTypes(produceTypes, "produceTypes");
        this.produces = ImmutableSet.copyOf(produceTypes);
        return this;
    }

    public RouteBuilder matchesParams(String ... paramPredicates) {
        return this.matchesParams((Iterable<String>)ImmutableList.copyOf(Objects.requireNonNull(paramPredicates, "paramPredicates")));
    }

    public RouteBuilder matchesParams(Iterable<String> paramPredicates) {
        this.paramPredicates.addAll(RoutingPredicate.copyOfParamPredicates(Objects.requireNonNull(paramPredicates, "paramPredicates")));
        return this;
    }

    public RouteBuilder matchesParams(String paramName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(paramName, "paramName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.paramPredicates.add(RoutingPredicate.ofParams(paramName, valuePredicate));
        return this;
    }

    RouteBuilder matchesParams(List<RoutingPredicate<QueryParams>> paramPredicates) {
        this.paramPredicates.addAll((Collection<RoutingPredicate<QueryParams>>)Objects.requireNonNull(paramPredicates, "paramPredicates"));
        return this;
    }

    public RouteBuilder matchesHeaders(String ... headerPredicates) {
        return this.matchesHeaders((Iterable<String>)ImmutableList.copyOf(Objects.requireNonNull(headerPredicates, "headerPredicates")));
    }

    public RouteBuilder matchesHeaders(Iterable<String> headerPredicates) {
        this.headerPredicates.addAll(RoutingPredicate.copyOfHeaderPredicates(Objects.requireNonNull(headerPredicates, "headerPredicates")));
        return this;
    }

    public RouteBuilder matchesHeaders(CharSequence headerName, Predicate<? super String> valuePredicate) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(valuePredicate, "valuePredicate");
        this.headerPredicates.add(RoutingPredicate.ofHeaders(headerName, valuePredicate));
        return this;
    }

    RouteBuilder matchesHeaders(List<RoutingPredicate<HttpHeaders>> headerPredicates) {
        this.headerPredicates.addAll((Collection<RoutingPredicate<HttpHeaders>>)Objects.requireNonNull(headerPredicates, "headerPredicates"));
        return this;
    }

    RouteBuilder fallback(boolean isFallback) {
        this.isFallback = isFallback;
        return this;
    }

    RouteBuilder exclude(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        this.excludedRoutes.add(Route.builder().path(pathPattern).build());
        return this;
    }

    RouteBuilder exclude(Route excludedRoute) {
        this.excludedRoutes.add(Objects.requireNonNull(excludedRoute, "excludedRoute"));
        return this;
    }

    RouteBuilder exclude(Iterable<? extends Route> excludedRoutes) {
        Iterables.addAll(this.excludedRoutes, Objects.requireNonNull(excludedRoutes, "excludedRoutes"));
        return this;
    }

    public Route build() {
        Preconditions.checkState(this.pathMapping != null, "Must set a path before calling this.");
        if (!(this.consumes.isEmpty() && this.produces.isEmpty() || !this.methods.isEmpty())) {
            throw new IllegalStateException("Must set methods if consumes or produces is not empty. consumes: " + this.consumes + ", produces: " + this.produces);
        }
        Set<HttpMethod> pathMethods = this.methods.isEmpty() ? HttpMethod.knownMethods() : this.methods;
        return new DefaultRoute(this.pathMapping, pathMethods, this.consumes, this.produces, this.paramPredicates, this.headerPredicates, this.isFallback, this.excludedRoutes);
    }

    public int hashCode() {
        return Objects.hash(this.pathMapping, this.methods, this.consumes, this.produces, this.paramPredicates, this.headerPredicates, this.isFallback, this.excludedRoutes);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RouteBuilder)) {
            return false;
        }
        RouteBuilder that = (RouteBuilder)o;
        return Objects.equals(this.pathMapping, that.pathMapping) && this.methods.equals(that.methods) && this.consumes.equals(that.consumes) && this.produces.equals(that.produces) && this.paramPredicates.equals(that.paramPredicates) && this.headerPredicates.equals(that.headerPredicates) && this.isFallback == that.isFallback && this.excludedRoutes.equals(that.excludedRoutes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("pathMapping", this.pathMapping).add("methods", this.methods).add("consumes", this.consumes).add("produces", this.produces).add("paramPredicates", this.paramPredicates).add("headerPredicates", this.headerPredicates).add("isFallback", this.isFallback).add("excludedRoutes", this.excludedRoutes).toString();
    }

    private static PathMapping getPathMapping(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (pathPattern.startsWith("exact:")) {
            return new ExactPathMapping(pathPattern.substring("exact:".length()));
        }
        if (pathPattern.startsWith("prefix:")) {
            String prefix = pathPattern.substring("prefix:".length());
            return RouteBuilder.prefixPathMapping(prefix, true);
        }
        if (pathPattern.startsWith("glob:")) {
            String glob = pathPattern.substring("glob:".length());
            return RouteBuilder.globPathMapping(glob, 0);
        }
        if (pathPattern.startsWith("regex:")) {
            return new RegexPathMapping(Pattern.compile(pathPattern.substring("regex:".length())));
        }
        if (!pathPattern.startsWith("/")) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (not an absolute path starting with '/' or a unknown pattern type)");
        }
        if (!pathPattern.contains("/{") && !pathPattern.contains("/:")) {
            return new ExactPathMapping(pathPattern);
        }
        return new ParameterizedPathMapping(pathPattern);
    }

    static PathMapping prefixPathMapping(String prefix, boolean stripPrefix) {
        if ("/".equals(prefix)) {
            return CatchAllPathMapping.INSTANCE;
        }
        return new PrefixPathMapping(prefix, stripPrefix);
    }
}

