/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.metric.MeterIdPrefix;
import karate.com.linecorp.armeria.internal.common.metric.CaffeineMetricSupport;
import karate.com.linecorp.armeria.internal.server.RouteDecoratingService;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import karate.com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.Router;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingContextWrapper;
import karate.com.linecorp.armeria.server.RoutingResult;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.io.micrometer.core.instrument.MeterRegistry;

final class RouteCache {
    @Nullable
    private static final Cache<RoutingContext, ServiceConfig> FIND_CACHE = Flags.routeCacheSpec() != null ? RouteCache.buildCache(Flags.routeCacheSpec()) : null;
    @Nullable
    private static final Cache<RoutingContext, List<ServiceConfig>> FIND_ALL_CACHE = Flags.routeCacheSpec() != null ? RouteCache.buildCache(Flags.routeCacheSpec()) : null;
    @Nullable
    private static final Cache<RoutingContext, RouteDecoratingService> DECORATOR_FIND_CACHE = Flags.routeDecoratorCacheSpec() != null ? RouteCache.buildCache(Flags.routeDecoratorCacheSpec()) : null;
    @Nullable
    private static final Cache<RoutingContext, List<RouteDecoratingService>> DECORATOR_FIND_ALL_CACHE = Flags.routeDecoratorCacheSpec() != null ? RouteCache.buildCache(Flags.routeDecoratorCacheSpec()) : null;

    static Router<ServiceConfig> wrapVirtualHostRouter(Router<ServiceConfig> delegate, Set<Route> dynamicPredicateRoutes) {
        if (FIND_CACHE == null) {
            return delegate;
        }
        assert (FIND_ALL_CACHE != null);
        return new CachingRouter<ServiceConfig>(delegate, ServiceConfig::route, FIND_CACHE, FIND_ALL_CACHE, dynamicPredicateRoutes);
    }

    static Router<RouteDecoratingService> wrapRouteDecoratingServiceRouter(Router<RouteDecoratingService> delegate, Set<Route> dynamicPredicateRoutes) {
        if (DECORATOR_FIND_CACHE == null) {
            return delegate;
        }
        assert (DECORATOR_FIND_ALL_CACHE != null);
        return new CachingRouter<RouteDecoratingService>(delegate, RouteDecoratingService::route, DECORATOR_FIND_CACHE, DECORATOR_FIND_ALL_CACHE, dynamicPredicateRoutes);
    }

    private static <T> Cache<RoutingContext, T> buildCache(String spec) {
        return Caffeine.from(spec).recordStats().build();
    }

    private RouteCache() {
    }

    private static final class CachingRouter<V>
    implements Router<V> {
        private final Router<V> delegate;
        private final Function<V, Route> routeResolver;
        private final Cache<RoutingContext, V> findCache;
        private final Cache<RoutingContext, List<V>> findAllCache;
        private final Set<Route> dynamicPredicateRoutes;

        CachingRouter(Router<V> delegate, Function<V, Route> routeResolver, Cache<RoutingContext, V> findCache, Cache<RoutingContext, List<V>> findAllCache, Set<Route> dynamicPredicateRoutes) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.routeResolver = Objects.requireNonNull(routeResolver, "routeResolver");
            this.findCache = Objects.requireNonNull(findCache, "findCache");
            this.findAllCache = Objects.requireNonNull(findAllCache, "findAllCache");
            Set newDynamicPredicateRoutes = Collections.newSetFromMap(new IdentityHashMap(dynamicPredicateRoutes.size()));
            newDynamicPredicateRoutes.addAll((Collection)Objects.requireNonNull(dynamicPredicateRoutes, "dynamicPredicateRoutes"));
            this.dynamicPredicateRoutes = Collections.unmodifiableSet(newDynamicPredicateRoutes);
        }

        @Override
        public Routed<V> find(RoutingContext routingCtx) {
            V cached = this.findCache.getIfPresent(routingCtx);
            if (cached != null) {
                Route route = this.routeResolver.apply(cached);
                RoutingResult routingResult = route.apply(routingCtx, false);
                return Routed.of(route, routingResult, cached);
            }
            Routed<V> result = this.delegate.find(routingCtx);
            if (result.isPresent() && result.route().isCacheable() && !this.dynamicPredicateRoutes.contains(result.route())) {
                this.findCache.put(routingCtx, result.value());
            }
            return result;
        }

        @Override
        public List<Routed<V>> findAll(RoutingContext routingCtx) {
            List<V> cachedList = this.findAllCache.getIfPresent(routingCtx);
            if (cachedList != null) {
                return this.filterRoutes(cachedList, routingCtx);
            }
            List<Routed<V>> result = this.delegate.findAll(this.dynamicPredicateRoutes.isEmpty() ? routingCtx : new CachingRoutingContext(routingCtx));
            List valid = result.stream().filter(Routed::isPresent).map(Routed::value).collect(ImmutableList.toImmutableList());
            this.findAllCache.put(routingCtx, valid);
            return this.filterRoutes(valid, routingCtx);
        }

        private List<Routed<V>> filterRoutes(List<V> list, RoutingContext routingCtx) {
            return list.stream().map(cached -> {
                Route route = this.routeResolver.apply(cached);
                RoutingResult routingResult = route.apply(routingCtx, false);
                return routingResult.isPresent() ? Routed.of(route, routingResult, cached) : Routed.empty();
            }).filter(Routed::isPresent).collect(ImmutableList.toImmutableList());
        }

        @Override
        public boolean registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
            CaffeineMetricSupport.setup(registry, idPrefix, this.findCache);
            return true;
        }

        @Override
        public void dump(OutputStream output) {
            this.delegate.dump(output);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate).add("findCache", this.findCache).add("findAllCache", this.findAllCache).toString();
        }
    }

    static final class CachingRoutingContext
    extends RoutingContextWrapper {
        CachingRoutingContext(RoutingContext delegate) {
            super(delegate);
        }

        @Override
        public boolean requiresMatchingParamsPredicates() {
            return false;
        }

        @Override
        public boolean requiresMatchingHeadersPredicates() {
            return false;
        }
    }
}

