/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.RoutingResult;
import karate.com.linecorp.armeria.server.RoutingResultType;

public final class Routed<T> {
    private static final Routed<Object> EMPTY = new Routed<Object>(null, RoutingResult.empty(), null);
    @Nullable
    private final Route route;
    private final RoutingResult routingResult;
    @Nullable
    private final T value;

    public static <T> Routed<T> empty() {
        return EMPTY;
    }

    static <T> Routed<T> of(Route route, RoutingResult routingResult, T value) {
        Objects.requireNonNull(route, "route");
        Objects.requireNonNull(routingResult, "routingResult");
        Objects.requireNonNull(value, "value");
        if (!routingResult.isPresent()) {
            throw new IllegalArgumentException("routingResult: " + routingResult + " (must be present)");
        }
        return new Routed<T>(route, routingResult, value);
    }

    private Routed(@Nullable Route route, RoutingResult routingResult, @Nullable T value) {
        assert (route != null && value != null || route == null && value == null);
        this.route = route;
        this.routingResult = routingResult;
        this.value = value;
    }

    public boolean isPresent() {
        return this.route != null;
    }

    public Route route() {
        this.ensurePresence();
        assert (this.route != null);
        return this.route;
    }

    public RoutingResult routingResult() {
        this.ensurePresence();
        return this.routingResult;
    }

    public RoutingResultType routingResultType() {
        return this.isPresent() ? this.routingResult.type() : RoutingResultType.NOT_MATCHED;
    }

    public T value() {
        this.ensurePresence();
        assert (this.value != null);
        return this.value;
    }

    private void ensurePresence() {
        if (!this.isPresent()) {
            throw new IllegalStateException("route unavailable");
        }
    }

    public String toString() {
        if (this.isPresent()) {
            return MoreObjects.toStringHelper(this).add("route", this.route).add("routingResult", this.routingResult).add("value", this.value).toString();
        }
        return this.getClass().getSimpleName() + "{<empty>}";
    }
}

