/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.List;
import java.util.Objects;
import karate.com.linecorp.armeria.common.Flags;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.QueryParams;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.RequestTarget;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.common.DefaultRequestTarget;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.RoutingContextWrapper;
import karate.com.linecorp.armeria.server.RoutingStatus;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.VirtualHost;

public interface RoutingContext {
    public VirtualHost virtualHost();

    public String hostname();

    public HttpMethod method();

    @UnstableApi
    default public RoutingContext withMethod(final HttpMethod method) {
        Objects.requireNonNull(method, "method");
        if (method == this.method()) {
            return this;
        }
        return new RoutingContextWrapper(this){

            @Override
            public HttpMethod method() {
                return method;
            }
        };
    }

    public RequestTarget requestTarget();

    default public String path() {
        return this.requestTarget().path();
    }

    @Nullable
    default public String query() {
        return this.requestTarget().query();
    }

    public QueryParams params();

    @Nullable
    public MediaType contentType();

    public List<MediaType> acceptTypes();

    public RequestHeaders headers();

    @UnstableApi
    public RoutingStatus status();

    @UnstableApi
    public SessionProtocol sessionProtocol();

    public void deferStatusException(HttpStatusException var1);

    @Nullable
    public HttpStatusException deferredStatusException();

    default public RoutingContext withPath(String path) {
        String pathWithoutMatrixVariables;
        Objects.requireNonNull(path, "path");
        if (Flags.allowSemicolonInPathComponent()) {
            pathWithoutMatrixVariables = path;
        } else {
            pathWithoutMatrixVariables = DefaultRequestTarget.removeMatrixVariables(path);
            Preconditions.checkArgument(pathWithoutMatrixVariables != null, "path with invalid matrix variables: %s", (Object)path);
        }
        RequestTarget oldReqTarget = this.requestTarget();
        final RequestTarget newReqTarget = DefaultRequestTarget.createWithoutValidation(oldReqTarget.form(), oldReqTarget.scheme(), oldReqTarget.authority(), oldReqTarget.host(), oldReqTarget.port(), pathWithoutMatrixVariables, path, path, oldReqTarget.query(), oldReqTarget.fragment());
        return new RoutingContextWrapper(this){

            @Override
            public RequestTarget requestTarget() {
                return newReqTarget;
            }
        };
    }

    @Deprecated
    default public RoutingContext overridePath(String path) {
        return this.withPath(path);
    }

    @Deprecated
    public boolean isCorsPreflight();

    default public boolean requiresMatchingParamsPredicates() {
        return true;
    }

    default public boolean requiresMatchingHeadersPredicates() {
        return true;
    }

    @UnstableApi
    public boolean hasResult();

    @UnstableApi
    public void setResult(Routed<ServiceConfig> var1);

    @UnstableApi
    public Routed<ServiceConfig> result();
}

