/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Objects;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.server.DefaultServerErrorHandler;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceErrorHandler;
import karate.com.linecorp.armeria.server.ServiceRequestContext;

@FunctionalInterface
@UnstableApi
public interface ServerErrorHandler {
    public static ServerErrorHandler ofDefault() {
        return DefaultServerErrorHandler.INSTANCE;
    }

    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext var1, Throwable var2);

    @Nullable
    default public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.renderStatus(null, config, headers, status, description, cause);
    }

    @Nullable
    default public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return null;
    }

    default public ServerErrorHandler orElse(final ServerErrorHandler other) {
        Objects.requireNonNull(other, "other");
        return new ServerErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                HttpResponse response = ServerErrorHandler.this.onServiceException(ctx, cause);
                if (response != null) {
                    return response;
                }
                return other.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse onProtocolViolation(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.onProtocolViolation(config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.onProtocolViolation(config, headers, status, description, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(@Nullable ServiceRequestContext ctx, ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                AggregatedHttpResponse response = ServerErrorHandler.this.renderStatus(ctx, config, headers, status, description, cause);
                if (response != null) {
                    return response;
                }
                return other.renderStatus(ctx, config, headers, status, description, cause);
            }
        };
    }

    default public ServiceErrorHandler asServiceErrorHandler() {
        return new ServiceErrorHandler(){

            @Override
            @Nullable
            public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
                return ServerErrorHandler.this.onServiceException(ctx, cause);
            }

            @Override
            @Nullable
            public AggregatedHttpResponse renderStatus(ServiceRequestContext ctx, RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
                return ServerErrorHandler.this.renderStatus(ctx, ctx.config(), headers, status, description, cause);
            }
        };
    }
}

