/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.Http1HeaderNaming;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import karate.com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import karate.com.linecorp.armeria.internal.common.KeepAliveHandler;
import karate.com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import karate.com.linecorp.armeria.server.Http1ServerKeepAliveHandler;
import karate.com.linecorp.armeria.server.ServerHttpObjectEncoder;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.io.netty.buffer.Unpooled;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.ChannelFuture;
import karate.io.netty.channel.ChannelFutureListener;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.handler.codec.http.DefaultFullHttpResponse;
import karate.io.netty.handler.codec.http.DefaultHttpResponse;
import karate.io.netty.handler.codec.http.HttpHeaderValues;
import karate.io.netty.handler.codec.http.HttpHeaders;
import karate.io.netty.handler.codec.http.HttpMessage;
import karate.io.netty.handler.codec.http.HttpObject;
import karate.io.netty.handler.codec.http.HttpResponse;
import karate.io.netty.handler.codec.http.HttpResponseStatus;
import karate.io.netty.handler.codec.http.HttpStatusClass;
import karate.io.netty.handler.codec.http.HttpUtil;
import karate.io.netty.handler.codec.http.HttpVersion;
import karate.io.netty.handler.codec.http2.Http2Error;
import karate.io.netty.util.ReferenceCountUtil;

final class ServerHttp1ObjectEncoder
extends Http1ObjectEncoder
implements ServerHttpObjectEncoder {
    private final KeepAliveHandler keepAliveHandler;
    private final Http1HeaderNaming http1HeaderNaming;
    private int lastResponseHeadersId;
    private boolean webSocketUpgrading;
    private boolean webSocketUpgraded;

    ServerHttp1ObjectEncoder(Channel ch, SessionProtocol protocol, KeepAliveHandler keepAliveHandler, Http1HeaderNaming http1HeaderNaming) {
        super(ch, protocol);
        assert (keepAliveHandler instanceof Http1ServerKeepAliveHandler || keepAliveHandler instanceof NoopKeepAliveHandler);
        this.keepAliveHandler = keepAliveHandler;
        this.http1HeaderNaming = http1HeaderNaming;
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty, HttpMethod method) {
        if (!this.isWritable(id)) {
            return this.newClosedSessionFuture();
        }
        if (this.webSocketUpgrading && headers.status() == HttpStatus.SWITCHING_PROTOCOLS) {
            this.webSocketUpgraded = true;
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, false);
            ArmeriaHttpUtil.toNettyHttp1Server(headers, res.headers(), this.http1HeaderNaming, false);
            return this.write(id, res, false);
        }
        HttpResponse converted = this.convertHeaders(headers, endStream, isTrailersEmpty, method);
        if (headers.status().isInformational()) {
            return this.write(id, converted, false);
        }
        return this.writeNonInformationalHeaders(id, converted, endStream, this.channel().newPromise());
    }

    private HttpResponse convertHeaders(ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty, HttpMethod method) {
        DefaultHttpResponse res;
        int statusCode = headers.status().code();
        HttpResponseStatus nettyStatus = HttpResponseStatus.valueOf(statusCode);
        if (headers.status().isInformational()) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER, false);
            ArmeriaHttpUtil.toNettyHttp1ServerHeaders(headers, res.headers(), this.http1HeaderNaming, true);
        } else if (endStream) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER, false);
            HttpHeaders outHeaders = res.headers();
            this.convertHeaders(headers, outHeaders, isTrailersEmpty);
            if (HttpStatus.isContentAlwaysEmpty(statusCode)) {
                ServerHttp1ObjectEncoder.maybeRemoveContentLength(statusCode, outHeaders);
            } else if (method != HttpMethod.HEAD && !headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                outHeaders.setInt(HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        } else {
            res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, false);
            this.convertHeaders(headers, res.headers(), isTrailersEmpty);
            ServerHttp1ObjectEncoder.maybeSetTransferEncoding(res, statusCode);
        }
        return res;
    }

    private void convertHeaders(ResponseHeaders inHeaders, HttpHeaders outHeaders, boolean isTrailersEmpty) {
        ArmeriaHttpUtil.toNettyHttp1ServerHeaders(inHeaders, outHeaders, this.http1HeaderNaming, !this.keepAliveHandler.needsDisconnection());
        if (!isTrailersEmpty && outHeaders.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            outHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    private static void maybeRemoveContentLength(int statusCode, HttpHeaders outHeaders) {
        if (statusCode != 304) {
            outHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    private static void maybeSetTransferEncoding(HttpMessage out, int statusCode) {
        HttpHeaders outHeaders = out.headers();
        if (HttpStatus.isContentAlwaysEmpty(statusCode)) {
            ServerHttp1ObjectEncoder.maybeRemoveContentLength(statusCode, outHeaders);
        } else {
            long contentLength = HttpUtil.getContentLength(out, -1L);
            if (contentLength < 0L) {
                outHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                outHeaders.remove(HttpHeaderNames.CONTENT_LENGTH);
            }
        }
    }

    @Override
    protected ChannelFuture write(HttpObject obj, ChannelPromise promise) {
        if (obj instanceof HttpResponse) {
            int currentId = this.currentId();
            if (this.lastResponseHeadersId >= currentId) {
                ReferenceCountUtil.release(obj);
                return this.writeReset(currentId, 1, Http2Error.PROTOCOL_ERROR, false);
            }
            if (this.webSocketUpgraded || ((HttpResponse)obj).status().codeClass() != HttpStatusClass.INFORMATIONAL) {
                this.lastResponseHeadersId = currentId;
            }
        }
        return this.channel().write(obj, promise);
    }

    @Override
    protected void convertTrailers(karate.com.linecorp.armeria.common.HttpHeaders inputHeaders, HttpHeaders outputHeaders) {
        ArmeriaHttpUtil.toNettyHttp1ServerTrailers(inputHeaders, outputHeaders, this.http1HeaderNaming);
    }

    @Override
    protected boolean isPing(int id) {
        return false;
    }

    @Override
    public boolean isResponseHeadersSent(int id, int streamId) {
        return id <= this.lastResponseHeadersId;
    }

    @Override
    public ChannelFuture writeErrorResponse(int id, int streamId, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        this.keepAliveHandler().disconnectWhenFinished();
        ChannelFuture future = ServerHttpObjectEncoder.super.writeErrorResponse(id, streamId, serviceConfig, headers, status, message, cause);
        this.updateClosedId(id);
        return future.addListener(ChannelFutureListener.CLOSE);
    }

    void webSocketUpgrading() {
        this.webSocketUpgrading = true;
    }
}

