/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.util.Objects;
import karate.com.linecorp.armeria.common.RpcRequest;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.util.ServiceNamingUtil;
import karate.com.linecorp.armeria.server.LengthBasedServiceNaming;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.SimpleTypeServiceNaming;

@FunctionalInterface
public interface ServiceNaming {
    public static ServiceNaming of(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        return ctx -> defaultServiceName;
    }

    public static ServiceNaming fullTypeName() {
        return ctx -> {
            RpcRequest rpcReq = ctx.rpcRequest();
            if (rpcReq != null) {
                return rpcReq.serviceName();
            }
            return ServiceNamingUtil.trimTrailingDollarSigns(ServiceNamingUtil.fullTypeHttpServiceName(ctx.config().service()));
        };
    }

    public static ServiceNaming simpleTypeName() {
        return SimpleTypeServiceNaming.INSTANCE;
    }

    public static ServiceNaming shorten(int targetLength) {
        return LengthBasedServiceNaming.of(targetLength);
    }

    public static ServiceNaming shorten() {
        return ServiceNaming.shorten(0);
    }

    @Nullable
    public String serviceName(ServiceRequestContext var1);
}

