/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;
import karate.com.linecorp.armeria.common.AbstractRequestContextBuilder;
import karate.com.linecorp.armeria.common.CommonPools;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RequestId;
import karate.com.linecorp.armeria.common.SessionProtocol;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.SystemInfo;
import karate.com.linecorp.armeria.internal.common.CancellationScheduler;
import karate.com.linecorp.armeria.internal.server.DefaultServiceRequestContext;
import karate.com.linecorp.armeria.server.DefaultRoutingContext;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.ProxiedAddresses;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.Routed;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.RoutingResult;
import karate.com.linecorp.armeria.server.RoutingStatus;
import karate.com.linecorp.armeria.server.Server;
import karate.com.linecorp.armeria.server.ServerBuilder;
import karate.com.linecorp.armeria.server.ServerListener;
import karate.com.linecorp.armeria.server.ServerListenerAdapter;
import karate.com.linecorp.armeria.server.ServiceBindingBuilder;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.ServiceNaming;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.buffer.ByteBufAllocator;
import karate.io.netty.channel.Channel;
import karate.io.netty.channel.EventLoop;

public final class ServiceRequestContextBuilder
extends AbstractRequestContextBuilder {
    private static final HttpService fakeService = (ctx, req) -> HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
    private static final ServerListener rejectingListener = new ServerListenerAdapter(){

        @Override
        public void serverStarting(Server server) {
            throw new UnsupportedOperationException();
        }
    };
    private final List<Consumer<? super ServerBuilder>> serverConfigurators = new ArrayList<Consumer<? super ServerBuilder>>(4);
    private HttpService service = fakeService;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Route route;
    @Nullable
    private RoutingResult routingResult;
    @Nullable
    private ProxiedAddresses proxiedAddresses;

    ServiceRequestContextBuilder(HttpRequest request) {
        super(true, request);
    }

    public ServiceRequestContextBuilder service(HttpService service) {
        this.service = Objects.requireNonNull(service, "service");
        return this;
    }

    public ServiceRequestContextBuilder defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        return this.defaultServiceNaming(ServiceNaming.of(defaultServiceName));
    }

    public ServiceRequestContextBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    public ServiceRequestContextBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    public ServiceRequestContextBuilder route(Route route) {
        this.route = Objects.requireNonNull(route, "route");
        return this;
    }

    public ServiceRequestContextBuilder routingResult(RoutingResult routingResult) {
        this.routingResult = Objects.requireNonNull(routingResult, "routingResult");
        return this;
    }

    public ServiceRequestContextBuilder proxiedAddresses(ProxiedAddresses proxiedAddresses) {
        this.proxiedAddresses = Objects.requireNonNull(proxiedAddresses, "proxiedAddresses");
        return this;
    }

    public ServiceRequestContextBuilder serverConfigurator(Consumer<? super ServerBuilder> serverConfigurator) {
        this.serverConfigurators.add(Objects.requireNonNull(serverConfigurator, "serverConfigurator"));
        return this;
    }

    public ServiceRequestContext build() {
        CancellationScheduler requestCancellationScheduler;
        ProxiedAddresses proxiedAddresses = this.proxiedAddresses != null ? this.proxiedAddresses : ProxiedAddresses.of(this.remoteAddress());
        ServerBuilder serverBuilder = Server.builder().meterRegistry(this.meterRegistry());
        ServiceBindingBuilder serviceBindingBuilder = this.route != null ? (ServiceBindingBuilder)serverBuilder.route().addRoute(this.route) : (ServiceBindingBuilder)serverBuilder.route().path(this.requestTarget().path());
        if (this.defaultServiceNaming != null) {
            serviceBindingBuilder.defaultServiceNaming(this.defaultServiceNaming);
        }
        if (this.defaultLogName != null) {
            serviceBindingBuilder.defaultLogName(this.defaultLogName);
        }
        serviceBindingBuilder.build(this.service);
        this.serverConfigurators.forEach(configurator -> configurator.accept(serverBuilder));
        Server server = serverBuilder.build();
        server.addListener(rejectingListener);
        ServiceConfig serviceCfg = ServiceRequestContextBuilder.findServiceConfig(server, this.service);
        HttpRequest req = this.request();
        assert (req != null);
        RoutingContext routingCtx = DefaultRoutingContext.of(server.config().defaultVirtualHost(), this.localAddress().getHostString(), this.requestTarget(), req.headers(), RoutingStatus.OK, this.sessionProtocol());
        RoutingResult routingResult = this.routingResult != null ? this.routingResult : RoutingResult.builder().path(this.requestTarget().path()).query(this.requestTarget().query()).build();
        Route route = Route.builder().path(this.requestTarget().path()).build();
        Routed<ServiceConfig> routed = Routed.of(route, routingResult, serviceCfg);
        routingCtx.setResult(routed);
        ExchangeType exchangeType = this.service.exchangeType(routingCtx);
        InetAddress clientAddress = server.config().clientAddressMapper().apply(proxiedAddresses).getAddress();
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop == null) {
            eventLoop = CommonPools.workerGroup().next();
        }
        if (this.timedOut()) {
            requestCancellationScheduler = CancellationScheduler.finished(true);
        } else {
            requestCancellationScheduler = CancellationScheduler.ofServer(0L);
            requestCancellationScheduler.initAndStart(eventLoop, CancellationScheduler.noopCancellationTask);
        }
        Channel ch = this.fakeChannel(eventLoop);
        return new DefaultServiceRequestContext(serviceCfg, ch, eventLoop, this.meterRegistry(), this.sessionProtocol(), this.id(), routingCtx, routingResult, exchangeType, req, this.sslSession(), proxiedAddresses, clientAddress, this.remoteAddress(), this.localAddress(), requestCancellationScheduler, this.isRequestStartTimeSet() ? this.requestStartTimeNanos() : System.nanoTime(), this.isRequestStartTimeSet() ? this.requestStartTimeMicros() : SystemInfo.currentTimeMicros(), HttpHeaders.of(), HttpHeaders.of(), serviceCfg.contextHook());
    }

    private static ServiceConfig findServiceConfig(Server server, HttpService service) {
        for (ServiceConfig cfg : server.config().defaultVirtualHost().serviceConfigs()) {
            if (cfg.service().as(service.getClass()) == null) continue;
            return cfg;
        }
        throw new Error();
    }

    @Override
    public ServiceRequestContextBuilder meterRegistry(MeterRegistry meterRegistry) {
        return (ServiceRequestContextBuilder)super.meterRegistry(meterRegistry);
    }

    @Override
    public ServiceRequestContextBuilder eventLoop(EventLoop eventLoop) {
        return (ServiceRequestContextBuilder)super.eventLoop(eventLoop);
    }

    @Override
    public ServiceRequestContextBuilder alloc(ByteBufAllocator alloc) {
        return (ServiceRequestContextBuilder)super.alloc(alloc);
    }

    @Override
    public ServiceRequestContextBuilder sessionProtocol(SessionProtocol sessionProtocol) {
        return (ServiceRequestContextBuilder)super.sessionProtocol(sessionProtocol);
    }

    @Override
    public ServiceRequestContextBuilder id(RequestId id) {
        return (ServiceRequestContextBuilder)super.id(id);
    }

    @Override
    public ServiceRequestContextBuilder remoteAddress(InetSocketAddress remoteAddress) {
        Objects.requireNonNull(remoteAddress, "remoteAddress");
        return (ServiceRequestContextBuilder)super.remoteAddress(remoteAddress);
    }

    @Override
    public ServiceRequestContextBuilder localAddress(InetSocketAddress localAddress) {
        Objects.requireNonNull(localAddress, "remoteAddress");
        return (ServiceRequestContextBuilder)super.localAddress(localAddress);
    }

    @Override
    public ServiceRequestContextBuilder sslSession(SSLSession sslSession) {
        return (ServiceRequestContextBuilder)super.sslSession(sslSession);
    }

    @Override
    public ServiceRequestContextBuilder requestStartTime(long requestStartTimeNanos, long requestStartTimeMicros) {
        return (ServiceRequestContextBuilder)super.requestStartTime(requestStartTimeNanos, requestStartTimeMicros);
    }

    @Override
    public ServiceRequestContextBuilder timedOut(boolean timedOut) {
        return (ServiceRequestContextBuilder)super.timedOut(timedOut);
    }
}

