/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.TlsProvider;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.TlsEngineType;
import karate.com.linecorp.armeria.internal.common.SslContextFactory;
import karate.com.linecorp.armeria.internal.common.TlsProviderUtil;
import karate.com.linecorp.armeria.server.ServerTlsConfig;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.netty.handler.ssl.SslContext;
import karate.io.netty.util.Mapping;

final class TlsProviderMapping
implements Mapping<String, SslContext> {
    private final SslContextFactory sslContextFactory;

    TlsProviderMapping(TlsProvider tlsProvider, TlsEngineType tlsEngineType, @Nullable ServerTlsConfig tlsConfig, MeterRegistry meterRegistry) {
        this.sslContextFactory = new SslContextFactory(tlsProvider, tlsEngineType, tlsConfig, meterRegistry);
    }

    @Override
    public SslContext map(@Nullable String hostname) {
        hostname = hostname == null ? "*" : TlsProviderUtil.normalizeHostname(hostname);
        return this.sslContextFactory.getOrCreate(SslContextFactory.SslContextMode.SERVER, hostname);
    }

    void release(SslContext sslContext) {
        this.sslContextFactory.release(sslContext);
    }
}

