/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server;

import karate.com.linecorp.armeria.common.ClosedSessionException;
import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import karate.com.linecorp.armeria.server.DecodedHttpRequest;
import karate.com.linecorp.armeria.server.HttpServerCodec;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.ServerHttpObjectEncoder;
import karate.com.linecorp.armeria.server.ServiceConfig;
import karate.com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import karate.io.netty.buffer.ByteBuf;
import karate.io.netty.channel.ChannelDuplexHandler;
import karate.io.netty.channel.ChannelHandlerContext;
import karate.io.netty.channel.ChannelPromise;
import karate.io.netty.handler.codec.http.HttpContent;
import karate.io.netty.handler.codec.http.HttpResponse;
import karate.io.netty.handler.codec.http.HttpResponseStatus;
import karate.io.netty.handler.codec.http.LastHttpContent;
import karate.io.netty.handler.codec.http2.Http2Error;
import karate.io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebSocketServiceChannelHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServiceChannelHandler.class);
    private final StreamingDecodedHttpRequest req;
    private final ServerHttpObjectEncoder encoder;
    private final ServiceConfig serviceConfig;

    WebSocketServiceChannelHandler(StreamingDecodedHttpRequest req, ServerHttpObjectEncoder encoder, ServiceConfig serviceConfig) {
        this.req = req;
        this.encoder = encoder;
        this.serviceConfig = serviceConfig;
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        this.req.close(ClosedSessionException.get());
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof InitiateConnectionShutdown) {
            this.encoder.keepAliveHandler().disconnectWhenFinished();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof DecodedHttpRequest) {
            ctx.fireChannelRead(msg);
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            return;
        }
        if (!(msg instanceof ByteBuf)) {
            logger.warn("{} Unexpected msg: {}", (Object)ctx.channel(), msg);
            return;
        }
        this.encoder.keepAliveHandler().onReadOrWrite();
        try {
            ByteBuf data = (ByteBuf)msg;
            int dataLength = data.readableBytes();
            if (dataLength != 0) {
                this.req.increaseTransferredBytes(dataLength);
                long maxContentLength = this.req.maxRequestLength();
                long transferredLength = this.req.transferredBytes();
                if (maxContentLength > 0L && transferredLength > maxContentLength) {
                    ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(maxContentLength).contentLength(this.req.headers()).transferred(transferredLength).build();
                    if (this.encoder.isResponseHeadersSent(this.req.id(), 1)) {
                        this.encoder.writeReset(this.req.id(), 1, Http2Error.PROTOCOL_ERROR, false);
                    } else {
                        this.encoder.writeErrorResponse(this.req.id(), 1, this.serviceConfig, this.req.headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, null, null);
                    }
                    this.req.abortResponse(HttpStatusException.of(HttpStatus.REQUEST_ENTITY_TOO_LARGE, (Throwable)cause), true);
                    return;
                }
                if (this.req.isOpen()) {
                    this.req.write(HttpData.wrap(data.retain()));
                }
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            ctx.write(msg, promise);
            if (status.code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                ctx.pipeline().remove(HttpServerCodec.class);
            }
            return;
        }
        if (msg instanceof HttpContent) {
            ctx.write(((HttpContent)msg).content(), promise);
            return;
        }
        ctx.write(msg, promise);
    }
}

