/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.annotation;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import karate.com.fasterxml.jackson.databind.JsonNode;
import karate.com.fasterxml.jackson.databind.ObjectMapper;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.common.JacksonUtil;
import karate.com.linecorp.armeria.internal.server.ResponseConversionUtil;
import karate.com.linecorp.armeria.internal.server.annotation.ClassUtil;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import karate.com.linecorp.armeria.server.streaming.JsonTextSequences;
import karate.org.reactivestreams.Publisher;

public final class JacksonResponseConverterFunction
implements ResponseConverterFunction {
    private static final ObjectMapper defaultObjectMapper = JacksonUtil.newDefaultObjectMapper();
    private final ObjectMapper mapper;

    public JacksonResponseConverterFunction() {
        this(defaultObjectMapper);
    }

    public JacksonResponseConverterFunction(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    @Nullable
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType produceType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (JsonNode.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (produceType != null) {
            if (produceType.isJson()) {
                return false;
            }
            if (produceType.is(MediaType.JSON_SEQ) && (Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz))) {
                return true;
            }
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType mediaType = headers.contentType();
        if (mediaType != null) {
            Charset charset;
            if (mediaType.isJson() && (charset = mediaType.charset(StandardCharsets.UTF_8)).contains(StandardCharsets.UTF_8)) {
                if (result instanceof Publisher) {
                    return ResponseConversionUtil.aggregateFrom((Publisher)result, headers, trailers, this::toJsonHttpData, ctx);
                }
                if (result instanceof Stream) {
                    return ResponseConversionUtil.aggregateFrom((Stream)result, headers, trailers, this::toJsonHttpData, ctx.blockingTaskExecutor());
                }
                return HttpResponse.of(headers, this.toJsonHttpData(result), trailers);
            }
            if (mediaType.is(MediaType.JSON_SEQ)) {
                if (result instanceof Publisher) {
                    return JsonTextSequences.fromPublisher(headers, (Publisher)result, trailers, this.mapper);
                }
                if (result instanceof Stream) {
                    return JsonTextSequences.fromStream(headers, (Stream)result, trailers, (Executor)ctx.blockingTaskExecutor(), this.mapper);
                }
                return JsonTextSequences.fromObject(headers, result, trailers, this.mapper);
            }
        } else if (result instanceof JsonNode) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.JSON_UTF_8).build(), this.toJsonHttpData(result), trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private HttpData toJsonHttpData(@Nullable Object value) {
        try {
            return HttpData.wrap(this.mapper.writeValueAsBytes(value));
        }
        catch (Exception e) {
            return (HttpData)Exceptions.throwUnsafely(e);
        }
    }
}

