/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.auth;

import java.util.concurrent.CompletionStage;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.auth.AuthorizationStatus;
import karate.com.linecorp.armeria.server.auth.AuthorizerChain;

@FunctionalInterface
public interface Authorizer<T> {
    public CompletionStage<Boolean> authorize(ServiceRequestContext var1, T var2);

    @UnstableApi
    default public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable T data) {
        if (data == null) {
            return UnmodifiableFuture.completedFuture(AuthorizationStatus.of(false));
        }
        return this.authorize(ctx, data).thenApply(b -> {
            if (b == null) {
                return null;
            }
            return AuthorizationStatus.of(b);
        });
    }

    default public Authorizer<T> orElse(Authorizer<T> nextAuthorizer) {
        Authorizer self = this;
        return new AuthorizerChain<T>(self, AuthorizerChain.AuthorizerSelectionStrategy.LAST_WITH_HANDLER).orElse(nextAuthorizer);
    }
}

