/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.auth.AuthToken;
import karate.com.linecorp.armeria.common.auth.BasicToken;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Strings;
import karate.io.netty.util.AsciiString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BasicTokenExtractor
implements Function<RequestHeaders, BasicToken> {
    private static final Logger logger = LoggerFactory.getLogger(BasicTokenExtractor.class);
    private static final Pattern AUTHORIZATION_HEADER_PATTERN = Pattern.compile("\\s*(?i)basic\\s+(?<encoded>\\S+)\\s*");
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private final AsciiString header;

    BasicTokenExtractor(CharSequence header) {
        this.header = HttpHeaderNames.of(header);
    }

    @Override
    @Nullable
    public BasicToken apply(RequestHeaders headers) {
        byte[] decoded;
        String authorization = Objects.requireNonNull(headers, "headers").get(this.header);
        if (Strings.isNullOrEmpty(authorization)) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_HEADER_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            logger.warn("Invalid authorization header: {}", (Object)authorization);
            return null;
        }
        String base64 = matcher.group("encoded");
        try {
            decoded = BASE64_DECODER.decode(base64);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Base64 decoding failed: {}", (Object)base64);
            return null;
        }
        String credential = new String(decoded, StandardCharsets.UTF_8);
        int sep = credential.indexOf(58);
        if (sep == -1) {
            logger.warn("Invalid credential: {}", (Object)credential);
            return null;
        }
        String username = credential.substring(0, sep);
        String password = credential.substring(sep + 1);
        return AuthToken.ofBasic(username, password);
    }
}

