/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.auth;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.auth.AbstractAuthorizerWithHandlers;
import karate.com.linecorp.armeria.server.auth.AuthorizationStatus;
import karate.com.linecorp.armeria.server.auth.Authorizer;

final class DelegatingHttpRequestAuthorizer<T>
extends AbstractAuthorizerWithHandlers<HttpRequest> {
    private final Function<? super RequestHeaders, @Nullable T> tokenExtractor;
    private final Authorizer<? super T> delegate;

    DelegatingHttpRequestAuthorizer(Function<? super RequestHeaders, @Nullable T> tokenExtractor, Authorizer<? super T> delegate) {
        this.tokenExtractor = Objects.requireNonNull(tokenExtractor, "tokenExtractor");
        this.delegate = Objects.requireNonNull(delegate, "authorizer");
    }

    @Override
    public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable HttpRequest request) {
        T token = this.tokenExtractor.apply(Objects.requireNonNull(request, "request").headers());
        return this.delegate.authorizeAndSupplyHandlers(ctx, token);
    }
}

