/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.cors;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.cors.AbstractCorsPolicyBuilder;
import karate.com.linecorp.armeria.server.cors.CorsServiceBuilder;

public final class ChainedCorsPolicyBuilder
extends AbstractCorsPolicyBuilder<ChainedCorsPolicyBuilder> {
    private static final List<String> ALLOW_ANY_ORIGIN = ImmutableList.of("*");
    private final CorsServiceBuilder serviceBuilder;

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder) {
        super(ALLOW_ANY_ORIGIN);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder, List<String> origins) {
        super(origins);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    ChainedCorsPolicyBuilder(CorsServiceBuilder builder, Predicate<? super String> originPredicate) {
        super(originPredicate);
        Objects.requireNonNull(builder, "builder");
        this.serviceBuilder = builder;
    }

    public CorsServiceBuilder and() {
        return this.serviceBuilder.addPolicy(this.build());
    }

    public ChainedCorsPolicyBuilder andForOrigins(String ... origins) {
        return this.and().andForOrigins(origins);
    }

    public ChainedCorsPolicyBuilder andForOrigin(String origin) {
        return this.and().andForOrigin(origin);
    }
}

