/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.cors;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import karate.com.linecorp.armeria.common.HttpMethod;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.cors.ChainedCorsPolicyBuilder;
import karate.com.linecorp.armeria.server.cors.CorsConfig;
import karate.com.linecorp.armeria.server.cors.CorsPolicy;
import karate.com.linecorp.armeria.server.cors.CorsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CorsServiceBuilder.class);
    final boolean anyOriginSupported;
    final ChainedCorsPolicyBuilder firstPolicyBuilder;
    final List<CorsPolicy> policies = new ArrayList<CorsPolicy>();
    boolean shortCircuit;

    CorsServiceBuilder(List<String> origins) {
        this.anyOriginSupported = false;
        this.firstPolicyBuilder = new ChainedCorsPolicyBuilder(this, origins);
    }

    CorsServiceBuilder(Predicate<? super String> originPredicate) {
        this.anyOriginSupported = false;
        this.firstPolicyBuilder = new ChainedCorsPolicyBuilder(this, originPredicate);
    }

    CorsServiceBuilder() {
        this.anyOriginSupported = true;
        this.firstPolicyBuilder = new ChainedCorsPolicyBuilder(this);
    }

    private void ensureForNewPolicy() {
        Preconditions.checkState(!this.anyOriginSupported, "You can not add more than one policy with any origin supported CORS service.");
    }

    public CorsServiceBuilder addPolicy(CorsPolicy policy) {
        this.ensureForNewPolicy();
        this.policies.add(policy);
        return this;
    }

    public CorsServiceBuilder route(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        this.firstPolicyBuilder.route(pathPattern);
        return this;
    }

    public CorsServiceBuilder allowNullOrigin() {
        Preconditions.checkState(!this.anyOriginSupported, "allowNullOrigin cannot be enabled with any origin supported CorsService.");
        this.firstPolicyBuilder.allowNullOrigin();
        return this;
    }

    public CorsServiceBuilder allowCredentials() {
        if (this.anyOriginSupported) {
            logger.warn("allowCredentials has been enabled for any origin (*). It will work properly but it would be better disabled or enabled with specified origins for security. Visit https://www.w3.org/TR/cors/#supports-credentials for more information.");
        }
        this.firstPolicyBuilder.allowCredentials();
        return this;
    }

    public CorsServiceBuilder shortCircuit() {
        Preconditions.checkState(!this.anyOriginSupported, "shortCircuit cannot be enabled with any origin supported CorsService.");
        this.shortCircuit = true;
        return this;
    }

    public CorsServiceBuilder maxAge(long maxAge) {
        this.firstPolicyBuilder.maxAge(maxAge);
        return this;
    }

    public CorsServiceBuilder maxAge(Duration maxAge) {
        Objects.requireNonNull(maxAge, "maxAge");
        return this.maxAge(TimeUnit.MILLISECONDS.toSeconds(maxAge.toMillis()));
    }

    public CorsServiceBuilder exposeHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.exposeHeaders(ImmutableList.copyOf(headers));
    }

    public CorsServiceBuilder exposeHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        this.firstPolicyBuilder.exposeHeaders((Iterable)headers);
        return this;
    }

    public CorsServiceBuilder allowRequestMethods(HttpMethod ... methods) {
        Objects.requireNonNull(methods, "methods");
        return this.allowRequestMethods(ImmutableList.copyOf(methods));
    }

    public CorsServiceBuilder allowRequestMethods(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        this.firstPolicyBuilder.allowRequestMethods((Iterable)methods);
        return this;
    }

    public CorsServiceBuilder allowAllRequestHeaders(boolean allowAllRequestHeaders) {
        this.firstPolicyBuilder.allowAllRequestHeaders(allowAllRequestHeaders);
        return this;
    }

    public CorsServiceBuilder allowRequestHeaders(CharSequence ... headers) {
        Objects.requireNonNull(headers, "headers");
        return this.allowRequestHeaders(ImmutableList.copyOf(headers));
    }

    public CorsServiceBuilder allowRequestHeaders(Iterable<? extends CharSequence> headers) {
        Objects.requireNonNull(headers, "headers");
        this.firstPolicyBuilder.allowRequestHeaders((Iterable)headers);
        return this;
    }

    public CorsServiceBuilder preflightResponseHeader(CharSequence name, Object ... values) {
        this.firstPolicyBuilder.preflightResponseHeader(name, values);
        return this;
    }

    public CorsServiceBuilder preflightResponseHeader(CharSequence name, Iterable<?> values) {
        this.firstPolicyBuilder.preflightResponseHeader(name, (Iterable)values);
        return this;
    }

    public CorsServiceBuilder preflightResponseHeader(CharSequence name, Supplier<?> valueSupplier) {
        this.firstPolicyBuilder.preflightResponseHeader(name, (Supplier)valueSupplier);
        return this;
    }

    public CorsServiceBuilder disablePreflightResponseHeaders() {
        this.firstPolicyBuilder.disablePreflightResponseHeaders();
        return this;
    }

    public CorsService build(HttpService delegate) {
        if (delegate.as(CorsService.class) != null) {
            throw new IllegalArgumentException("decorated with a " + CorsService.class.getSimpleName() + " already: " + delegate);
        }
        return new CorsService(delegate, new CorsConfig(this));
    }

    public Function<? super HttpService, CorsService> newDecorator() {
        return this::build;
    }

    public ChainedCorsPolicyBuilder andForOrigins(String ... origins) {
        Objects.requireNonNull(origins, "origins");
        return this.andForOrigins(ImmutableList.copyOf(origins));
    }

    public ChainedCorsPolicyBuilder andForOrigins(Iterable<String> origins) {
        Objects.requireNonNull(origins, "origins");
        this.ensureForNewPolicy();
        return new ChainedCorsPolicyBuilder(this, ImmutableList.copyOf(origins));
    }

    public ChainedCorsPolicyBuilder andForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin");
        return this.andForOrigins(ImmutableList.of(origin));
    }

    @UnstableApi
    public ChainedCorsPolicyBuilder andForOrigin(Predicate<String> originPredicate) {
        Objects.requireNonNull(originPredicate, "originPredicate");
        return new ChainedCorsPolicyBuilder(this, originPredicate);
    }

    @UnstableApi
    public ChainedCorsPolicyBuilder andForOriginRegex(String regex) {
        Objects.requireNonNull(regex, "regex");
        return this.andForOriginRegex(Pattern.compile(regex));
    }

    @UnstableApi
    public ChainedCorsPolicyBuilder andForOriginRegex(Pattern regex) {
        return this.andForOrigin(Objects.requireNonNull(regex, "regex").asPredicate());
    }

    public String toString() {
        return CorsConfig.toString(this, this.anyOriginSupported, this.shortCircuit, this.policies);
    }
}

