/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.util.List;
import java.util.Objects;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.docs.DefaultTypeSignature;
import karate.com.linecorp.armeria.server.docs.TypeSignature;
import karate.com.linecorp.armeria.server.docs.TypeSignatureType;

@UnstableApi
public class ContainerTypeSignature
extends DefaultTypeSignature {
    private static final Joiner JOINER = Joiner.on(", ");
    private final List<TypeSignature> typeParameters;

    ContainerTypeSignature(TypeSignatureType type, String name, List<TypeSignature> typeParameters) {
        super(type, name);
        ImmutableList<TypeSignature> typeParametersCopy = ImmutableList.copyOf(typeParameters);
        Preconditions.checkArgument(!typeParametersCopy.isEmpty(), "typeParameters is empty.");
        this.typeParameters = typeParametersCopy;
    }

    public List<TypeSignature> typeParameters() {
        return this.typeParameters;
    }

    @Override
    public String signature() {
        return this.name() + '<' + JOINER.join(this.typeParameters) + '>';
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerTypeSignature)) {
            return false;
        }
        ContainerTypeSignature that = (ContainerTypeSignature)o;
        return this.type() == that.type() && this.name().equals(that.name()) && Objects.equals(this.typeParameters, that.typeParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.name(), this.typeParameters});
    }
}

