/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.util.Objects;
import karate.com.fasterxml.jackson.annotation.JsonProperty;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.annotation.Description;
import karate.com.linecorp.armeria.server.docs.Markup;

@UnstableApi
public final class DescriptionInfo {
    private static final DescriptionInfo EMPTY = new DescriptionInfo("", Markup.NONE);
    private final String docString;
    private final Markup markup;

    public static DescriptionInfo of(String docString, Markup markup) {
        return new DescriptionInfo(docString, markup);
    }

    public static DescriptionInfo of(String docString) {
        return new DescriptionInfo(docString, Markup.NONE);
    }

    public static DescriptionInfo from(Description description) {
        Objects.requireNonNull(description, "description");
        return DescriptionInfo.of(description.value(), description.markup());
    }

    public static DescriptionInfo empty() {
        return EMPTY;
    }

    private DescriptionInfo(String docString, Markup markup) {
        this.docString = Objects.requireNonNull(docString, "docString");
        this.markup = Objects.requireNonNull(markup, "markup");
    }

    @JsonProperty
    public String docString() {
        return this.docString;
    }

    @JsonProperty
    public Markup markup() {
        return this.markup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DescriptionInfo)) {
            return false;
        }
        DescriptionInfo that = (DescriptionInfo)o;
        return this.docString.equals(that.docString) && this.markup == that.markup;
    }

    public int hashCode() {
        return karate.com.linecorp.armeria.internal.shaded.guava.base.Objects.hashCode(new Object[]{this.docString, this.markup});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("docString", this.docString).add("markup", (Object)this.markup).toString();
    }
}

