/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.util.Objects;
import java.util.regex.Pattern;

@FunctionalInterface
public interface DocServiceFilter {
    public static DocServiceFilter ofThrift() {
        return DocServiceFilter.ofPluginName("thrift");
    }

    public static DocServiceFilter ofGrpc() {
        return DocServiceFilter.ofPluginName("grpc");
    }

    public static DocServiceFilter ofAnnotated() {
        return DocServiceFilter.ofPluginName("annotated");
    }

    public static DocServiceFilter ofGraphql() {
        return DocServiceFilter.ofPluginName("graphql");
    }

    public static DocServiceFilter ofPluginName(String pluginName) {
        Objects.requireNonNull(pluginName, "pluginName");
        return (plugin, service, method) -> pluginName.equals(plugin);
    }

    public static DocServiceFilter ofServiceName(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName");
        return (plugin, service, method) -> serviceName.equals(service);
    }

    public static DocServiceFilter ofServiceName(String pluginName, String serviceName) {
        Objects.requireNonNull(pluginName, "pluginName");
        Objects.requireNonNull(serviceName, "serviceName");
        return (plugin, service, method) -> pluginName.equals(plugin) && serviceName.equals(service);
    }

    public static DocServiceFilter ofMethodName(String methodName) {
        Objects.requireNonNull(methodName, "methodName");
        return (plugin, service, method) -> methodName.equals(method);
    }

    public static DocServiceFilter ofMethodName(String serviceName, String methodName) {
        return (plugin, service, method) -> serviceName.equals(service) && methodName.equals(method);
    }

    public static DocServiceFilter ofMethodName(String pluginName, String serviceName, String methodName) {
        return (plugin, service, method) -> pluginName.equals(plugin) && serviceName.equals(service) && methodName.equals(method);
    }

    public static DocServiceFilter ofRegex(String regex) {
        Objects.requireNonNull(regex, "regex");
        return DocServiceFilter.ofRegex(Pattern.compile(regex));
    }

    public static DocServiceFilter ofRegex(Pattern pattern) {
        Objects.requireNonNull(pattern, "pattern");
        return (plugin, service, method) -> {
            String concatenatedName = plugin + ':' + service + '#' + method;
            return pattern.matcher(concatenatedName).find();
        };
    }

    public boolean test(String var1, String var2, String var3);

    default public DocServiceFilter or(DocServiceFilter other) {
        Objects.requireNonNull(other, "other");
        return (pluginName, serviceName, methodName) -> this.test(pluginName, serviceName, methodName) || other.test(pluginName, serviceName, methodName);
    }

    default public DocServiceFilter and(DocServiceFilter other) {
        Objects.requireNonNull(other, "other");
        return (pluginName, serviceName, methodName) -> this.test(pluginName, serviceName, methodName) && other.test(pluginName, serviceName, methodName);
    }
}

