/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import karate.com.linecorp.armeria.internal.shaded.guava.io.Resources;
import karate.com.linecorp.armeria.internal.shaded.reflections.Reflections;
import karate.com.linecorp.armeria.internal.shaded.reflections.Store;
import karate.com.linecorp.armeria.internal.shaded.reflections.scanners.ResourcesScanner;
import karate.com.linecorp.armeria.internal.shaded.reflections.util.ClasspathHelper;
import karate.com.linecorp.armeria.internal.shaded.reflections.util.ConfigurationBuilder;
import karate.com.linecorp.armeria.internal.shaded.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public abstract class DocStringExtractor {
    private static final Logger logger = LoggerFactory.getLogger(DocStringExtractor.class);
    private static final Map<ClassLoader, Map<String, String>> cached = new ConcurrentHashMap<ClassLoader, Map<String, String>>();
    private final String path;

    protected DocStringExtractor(String defaultPath, String pathPropertyName) {
        this.path = DocStringExtractor.computePath(defaultPath, pathPropertyName);
    }

    public final Map<String, String> getAllDocStrings(ClassLoader classLoader) {
        Objects.requireNonNull(classLoader, "classLoader");
        return cached.computeIfAbsent(classLoader, this::getAllDocStrings0);
    }

    private Map<String, String> getAllDocStrings0(ClassLoader classLoader) {
        ConfigurationBuilder configuration = new ConfigurationBuilder().filterInputsBy(new FilterBuilder().includePackage(this.path)).setUrls(ClasspathHelper.forPackage(this.path, classLoader)).addClassLoader(classLoader).setScanners(new ResourcesScanner());
        if (configuration.getUrls() == null || configuration.getUrls().isEmpty()) {
            return ImmutableMap.of();
        }
        Reflections reflections = new Reflections(configuration);
        Store store = reflections.getStore();
        if (!store.keySet().contains(ResourcesScanner.class.getSimpleName())) {
            return ImmutableMap.of();
        }
        Map files = reflections.getResources(this::acceptFile).stream().map(f -> {
            try {
                URL url = classLoader.getResource((String)f);
                if (url == null) {
                    throw new IllegalStateException("not found: " + f);
                }
                return Maps.immutableEntry(f, Resources.toByteArray(url));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return this.getDocStringsFromFiles(files);
    }

    protected boolean acceptFile(String filename) {
        return true;
    }

    protected abstract Map<String, String> getDocStringsFromFiles(Map<String, byte[]> var1);

    private static String computePath(String defaultPath, String pathPropertyName) {
        String dir = System.getProperty(pathPropertyName, defaultPath);
        if (dir.startsWith("/") || dir.startsWith("\\")) {
            dir = dir.substring(1);
        }
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        logger.info("Using {}: {}", (Object)pathPropertyName, (Object)dir);
        return dir;
    }
}

