/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.util.Objects;
import karate.com.fasterxml.jackson.annotation.JsonInclude;
import karate.com.fasterxml.jackson.annotation.JsonProperty;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.docs.DescriptionInfo;

@UnstableApi
public final class EnumValueInfo {
    private final String name;
    private final DescriptionInfo descriptionInfo;
    @Nullable
    private final Integer intValue;

    public EnumValueInfo(String name) {
        this(name, null, DescriptionInfo.empty());
    }

    public EnumValueInfo(String name, @Nullable Integer intValue) {
        this(name, intValue, DescriptionInfo.empty());
    }

    public EnumValueInfo(String name, @Nullable Integer intValue, DescriptionInfo descriptionInfo) {
        this.name = Objects.requireNonNull(name, "name");
        this.intValue = intValue;
        this.descriptionInfo = descriptionInfo;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Integer intValue() {
        return this.intValue;
    }

    @JsonProperty
    public DescriptionInfo descriptionInfo() {
        return this.descriptionInfo;
    }

    public EnumValueInfo withDescriptionInfo(DescriptionInfo descriptionInfo) {
        Objects.requireNonNull(descriptionInfo, "descriptionInfo");
        if (descriptionInfo.equals(this.descriptionInfo)) {
            return this;
        }
        return new EnumValueInfo(this.name, this.intValue, descriptionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.intValue, this.descriptionInfo);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumValueInfo)) {
            return false;
        }
        EnumValueInfo that = (EnumValueInfo)o;
        return this.name.equals(that.name) && Objects.equals(this.intValue, that.intValue) && this.descriptionInfo.equals(that.descriptionInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("intValue", this.intValue).add("descriptionInfo", this.descriptionInfo).toString();
    }
}

