/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.docs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import karate.com.fasterxml.jackson.annotation.JsonProperty;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import karate.com.linecorp.armeria.server.Route;
import karate.com.linecorp.armeria.server.RoutePathType;
import karate.com.linecorp.armeria.server.docs.DescriptiveTypeInfo;
import karate.com.linecorp.armeria.server.docs.DescriptiveTypeSignature;
import karate.com.linecorp.armeria.server.docs.EnumInfo;
import karate.com.linecorp.armeria.server.docs.ExceptionInfo;
import karate.com.linecorp.armeria.server.docs.ServiceInfo;
import karate.com.linecorp.armeria.server.docs.StructInfo;
import karate.com.linecorp.armeria.server.docs.TypeSignature;

@UnstableApi
public final class ServiceSpecification {
    private static final ServiceSpecification emptyServiceSpecification = new ServiceSpecification(ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), null);
    private final Set<ServiceInfo> services;
    private final Set<EnumInfo> enums;
    private final Set<StructInfo> structs;
    private final Set<ExceptionInfo> exceptions;
    private final List<HttpHeaders> exampleHeaders;
    @Nullable
    private final Route docServiceRoute;

    public static ServiceSpecification merge(Iterable<ServiceSpecification> specs, Route docServiceRoute) {
        return new ServiceSpecification(Streams.stream(specs).flatMap(s -> s.services().stream())::iterator, Streams.stream(specs).flatMap(s -> s.enums().stream())::iterator, Streams.stream(specs).flatMap(s -> s.structs().stream())::iterator, Streams.stream(specs).flatMap(s -> s.exceptions().stream())::iterator, ImmutableList.of(), docServiceRoute);
    }

    public static ServiceSpecification generate(Iterable<ServiceInfo> services, Function<DescriptiveTypeSignature, ? extends DescriptiveTypeInfo> descriptiveTypeInfoFactory) {
        if (Iterables.isEmpty(services)) {
            return emptyServiceSpecification;
        }
        Set descriptiveTypes = Streams.stream(services).flatMap(s -> s.findDescriptiveTypes().stream()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(TypeSignature::name)));
        HashMap<String, EnumInfo> enums = new HashMap<String, EnumInfo>();
        HashMap<String, StructInfo> structs = new HashMap<String, StructInfo>();
        HashMap<String, ExceptionInfo> exceptions = new HashMap<String, ExceptionInfo>();
        ServiceSpecification.generateDescriptiveTypeInfos(descriptiveTypeInfoFactory, enums, structs, exceptions, descriptiveTypes);
        return new ServiceSpecification(services, enums.values(), structs.values(), exceptions.values());
    }

    private static void generateDescriptiveTypeInfos(Function<DescriptiveTypeSignature, ? extends DescriptiveTypeInfo> descriptiveTypeInfoFactory, Map<String, EnumInfo> enums, Map<String, StructInfo> structs, Map<String, ExceptionInfo> exceptions, Set<DescriptiveTypeSignature> descriptiveTypes) {
        descriptiveTypes.forEach(type -> {
            String typeName = type.name();
            if (enums.containsKey(typeName) || structs.containsKey(typeName) || exceptions.containsKey(typeName)) {
                return;
            }
            DescriptiveTypeInfo newInfo = (DescriptiveTypeInfo)descriptiveTypeInfoFactory.apply((DescriptiveTypeSignature)type);
            if (newInfo instanceof EnumInfo) {
                enums.put(newInfo.name(), (EnumInfo)newInfo);
                return;
            }
            if (newInfo instanceof StructInfo) {
                structs.put(newInfo.name(), (StructInfo)newInfo);
            } else if (newInfo instanceof ExceptionInfo) {
                exceptions.put(newInfo.name(), (ExceptionInfo)newInfo);
            } else {
                throw new Error();
            }
            ServiceSpecification.generateDescriptiveTypeInfos(descriptiveTypeInfoFactory, enums, structs, exceptions, newInfo.findDescriptiveTypes());
        });
    }

    public ServiceSpecification(Iterable<ServiceInfo> services, Iterable<EnumInfo> enums, Iterable<StructInfo> structs, Iterable<ExceptionInfo> exceptions) {
        this(services, enums, structs, exceptions, ImmutableList.of(), null);
    }

    public ServiceSpecification(Iterable<ServiceInfo> services, Iterable<EnumInfo> enums, Iterable<StructInfo> structs, Iterable<ExceptionInfo> exceptions, Iterable<HttpHeaders> exampleHeaders) {
        this(services, enums, structs, exceptions, exampleHeaders, null);
    }

    public ServiceSpecification(Iterable<ServiceInfo> services, Iterable<EnumInfo> enums, Iterable<StructInfo> structs, Iterable<ExceptionInfo> exceptions, Iterable<HttpHeaders> exampleHeaders, @Nullable Route docServiceRoute) {
        this.services = Streams.stream(Objects.requireNonNull(services, "services")).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(ServiceInfo::name)));
        this.enums = ServiceSpecification.collectDescriptiveTypeInfo(enums, "enums");
        this.structs = ServiceSpecification.collectStructInfo(structs);
        this.exceptions = ServiceSpecification.collectDescriptiveTypeInfo(exceptions, "exceptions");
        this.exampleHeaders = ImmutableList.copyOf(Objects.requireNonNull(exampleHeaders, "exampleHeaders"));
        this.docServiceRoute = docServiceRoute != null && docServiceRoute.pathType() == RoutePathType.PREFIX ? docServiceRoute : null;
    }

    private static <T extends DescriptiveTypeInfo> Set<T> collectDescriptiveTypeInfo(Iterable<T> values, String name) {
        return Streams.stream(Objects.requireNonNull(values, name)).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(DescriptiveTypeInfo::name)));
    }

    private static Set<StructInfo> collectStructInfo(Iterable<StructInfo> structInfos) {
        Objects.requireNonNull(structInfos, "structInfos");
        return Streams.stream(structInfos).collect(Collectors.toMap(StructInfo::name, Function.identity(), (a, b) -> {
            if (a.alias() != null) {
                return a;
            }
            if (b.alias() != null) {
                return b;
            }
            return a;
        })).values().stream().collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(StructInfo::name)));
    }

    @JsonProperty
    public Set<ServiceInfo> services() {
        return this.services;
    }

    @JsonProperty
    public Set<EnumInfo> enums() {
        return this.enums;
    }

    @JsonProperty
    public Set<StructInfo> structs() {
        return this.structs;
    }

    @JsonProperty
    public Set<ExceptionInfo> exceptions() {
        return this.exceptions;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHeaders() {
        return this.exampleHeaders;
    }

    @JsonProperty
    @Nullable
    public Route docServiceRoute() {
        return this.docServiceRoute;
    }
}

