/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.encoding;

import java.util.function.Function;
import java.util.function.Predicate;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.RequestHeaders;
import karate.com.linecorp.armeria.internal.common.encoding.StreamEncoderFactory;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.Service;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.SimpleDecoratingHttpService;
import karate.com.linecorp.armeria.server.encoding.EncodingServiceBuilder;
import karate.com.linecorp.armeria.server.encoding.HttpEncodedResponse;
import karate.com.linecorp.armeria.server.encoding.HttpEncoders;

public final class EncodingService
extends SimpleDecoratingHttpService {
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final Predicate<? super RequestHeaders> encodableRequestHeadersPredicate;
    private final long minBytesToForceChunkedAndEncoding;

    public static EncodingServiceBuilder builder() {
        return new EncodingServiceBuilder();
    }

    public static Function<? super HttpService, EncodingService> newDecorator() {
        return EncodingService.builder().newDecorator();
    }

    EncodingService(HttpService delegate, Predicate<MediaType> encodableContentTypePredicate, Predicate<? super RequestHeaders> encodableRequestHeadersPredicate, long minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        this.encodableRequestHeadersPredicate = encodableRequestHeadersPredicate;
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.BIDI_STREAMING;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        StreamEncoderFactory encoderFactory = HttpEncoders.getEncoderFactory(req.headers());
        HttpResponse delegateResponse = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        if (encoderFactory == null || !this.encodableRequestHeadersPredicate.test(req.headers())) {
            return delegateResponse;
        }
        return new HttpEncodedResponse(delegateResponse, encoderFactory, this.encodableContentTypePredicate, ctx.alloc(), this.minBytesToForceChunkedAndEncoding);
    }
}

