/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.encoding;

import karate.com.linecorp.armeria.common.ContentTooLargeException;
import karate.com.linecorp.armeria.common.FilteredHttpRequest;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpObject;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.encoding.StreamDecoder;
import karate.com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import karate.com.linecorp.armeria.common.util.CompositeException;
import karate.io.netty.buffer.ByteBufAllocator;
import karate.org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpDecodedRequest
extends FilteredHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpDecodedRequest.class);
    private final StreamDecoder requestDecoder;
    private boolean decoderFinished;

    HttpDecodedRequest(HttpRequest delegate, StreamDecoderFactory decoderFactory, ByteBufAllocator alloc, int maxRequestLength) {
        super(delegate);
        this.requestDecoder = decoderFactory.newDecoder(alloc, maxRequestLength);
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpData) {
            return this.requestDecoder.decode((HttpData)obj);
        }
        return obj;
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeRequestDecoder();
        if (lastData == null) {
            return;
        }
        if (!lastData.isEmpty()) {
            subscriber.onNext(lastData);
        } else {
            lastData.close();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        try {
            HttpData lastData = this.closeRequestDecoder();
            if (lastData != null) {
                lastData.close();
            }
            return cause;
        }
        catch (Exception decoderException) {
            return new CompositeException(cause, decoderException);
        }
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        try {
            HttpData lastData = this.closeRequestDecoder();
            if (lastData != null) {
                lastData.close();
            }
        }
        catch (ContentTooLargeException cause) {
            logger.warn("A request content exceeds the maximum allowed request length. headers: {}", (Object)this.headers(), (Object)cause);
        }
    }

    @Nullable
    private HttpData closeRequestDecoder() {
        if (this.decoderFinished) {
            return null;
        }
        this.decoderFinished = true;
        return this.requestDecoder.finish();
    }
}

