/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import karate.com.linecorp.armeria.common.CacheControl;
import karate.com.linecorp.armeria.common.HttpHeaderNames;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.HttpHeadersBuilder;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.server.file.DefaultEntityTagFunction;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;

public abstract class AbstractHttpFileBuilder {
    private Clock clock = Clock.systemUTC();
    private boolean dateEnabled = true;
    private boolean lastModifiedEnabled = true;
    private boolean contentTypeAutoDetectionEnabled = true;
    @Nullable
    private BiFunction<String, HttpFileAttributes, String> entityTagFunction = DefaultEntityTagFunction.get();
    @Nullable
    private HttpHeadersBuilder headers;

    protected final Clock clock() {
        return this.clock;
    }

    public AbstractHttpFileBuilder clock(Clock clock) {
        this.clock = Objects.requireNonNull(clock, "clock");
        return this;
    }

    protected final boolean isDateEnabled() {
        return this.dateEnabled;
    }

    public AbstractHttpFileBuilder date(boolean dateEnabled) {
        this.dateEnabled = dateEnabled;
        return this;
    }

    protected final boolean isLastModifiedEnabled() {
        return this.lastModifiedEnabled;
    }

    public AbstractHttpFileBuilder lastModified(boolean lastModifiedEnabled) {
        this.lastModifiedEnabled = lastModifiedEnabled;
        return this;
    }

    protected final boolean isContentTypeAutoDetectionEnabled() {
        if (this.headers != null && this.headers.contains(HttpHeaderNames.CONTENT_TYPE)) {
            return false;
        }
        return this.contentTypeAutoDetectionEnabled;
    }

    public AbstractHttpFileBuilder autoDetectedContentType(boolean contentTypeAutoDetectionEnabled) {
        this.contentTypeAutoDetectionEnabled = contentTypeAutoDetectionEnabled;
        return this;
    }

    @Nullable
    protected final BiFunction<String, HttpFileAttributes, String> entityTagFunction() {
        return this.entityTagFunction;
    }

    public AbstractHttpFileBuilder entityTag(boolean enabled) {
        this.entityTagFunction = enabled ? DefaultEntityTagFunction.get() : null;
        return this;
    }

    public AbstractHttpFileBuilder entityTag(BiFunction<String, HttpFileAttributes, String> entityTagFunction) {
        this.entityTagFunction = Objects.requireNonNull(entityTagFunction, "entityTagFunction");
        return this;
    }

    protected final HttpHeaders buildHeaders() {
        return this.headers != null ? this.headers.removeAndThen(HttpHeaderNames.STATUS).build() : HttpHeaders.of();
    }

    private HttpHeadersBuilder headersBuilder() {
        if (this.headers == null) {
            this.headers = HttpHeaders.builder();
        }
        return this.headers;
    }

    public AbstractHttpFileBuilder addHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headersBuilder().addObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public AbstractHttpFileBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().addObject(headers);
        return this;
    }

    public AbstractHttpFileBuilder setHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.headersBuilder().setObject((CharSequence)HttpHeaderNames.of(name), value);
        return this;
    }

    public AbstractHttpFileBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        Objects.requireNonNull(headers, "headers");
        this.headersBuilder().setObject(headers);
        return this;
    }

    public AbstractHttpFileBuilder contentType(MediaType contentType) {
        Objects.requireNonNull(contentType, "contentType");
        this.autoDetectedContentType(false);
        this.headersBuilder().contentType(contentType);
        return this;
    }

    public AbstractHttpFileBuilder contentType(CharSequence contentType) {
        Objects.requireNonNull(contentType, "contentType");
        this.autoDetectedContentType(false);
        return this.setHeader(HttpHeaderNames.CONTENT_TYPE, contentType);
    }

    public AbstractHttpFileBuilder cacheControl(CacheControl cacheControl) {
        Objects.requireNonNull(cacheControl, "cacheControl");
        return this.setHeader(HttpHeaderNames.CACHE_CONTROL, cacheControl);
    }

    public AbstractHttpFileBuilder cacheControl(CharSequence cacheControl) {
        Objects.requireNonNull(cacheControl, "cacheControl");
        return this.setHeader(HttpHeaderNames.CACHE_CONTROL, cacheControl);
    }
}

