/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.util.Objects;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.server.file.AggregatedHttpFileBuilder;
import karate.com.linecorp.armeria.server.file.HttpFile;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.com.linecorp.armeria.server.file.NonExistentAggregatedHttpFile;

public interface AggregatedHttpFile {
    public static AggregatedHttpFile of(HttpData data) {
        return AggregatedHttpFile.builder(data).build();
    }

    public static AggregatedHttpFile of(HttpData data, long lastModifiedMillis) {
        Objects.requireNonNull(data, "data");
        return AggregatedHttpFile.builder(data, lastModifiedMillis).build();
    }

    public static AggregatedHttpFile nonExistent() {
        return NonExistentAggregatedHttpFile.INSTANCE;
    }

    public static AggregatedHttpFileBuilder builder(HttpData data) {
        return AggregatedHttpFile.builder(data, System.currentTimeMillis());
    }

    public static AggregatedHttpFileBuilder builder(HttpData data, long lastModifiedMillis) {
        Objects.requireNonNull(data, "data");
        return new AggregatedHttpFileBuilder(data, lastModifiedMillis).autoDetectedContentType(false);
    }

    @Nullable
    public HttpFileAttributes attributes();

    @Nullable
    public ResponseHeaders headers();

    @Nullable
    default public AggregatedHttpResponse response() {
        ResponseHeaders headers = this.headers();
        if (headers == null) {
            return null;
        }
        HttpData content = this.content();
        if (!1.$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        return AggregatedHttpResponse.of(headers, content);
    }

    @Nullable
    public HttpData content();

    public HttpFile toHttpFile();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

