/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.file.AggregatedHttpFile;
import karate.com.linecorp.armeria.server.file.HttpFile;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.io.netty.buffer.ByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachingHttpFile
implements HttpFile {
    private static final Logger logger = LoggerFactory.getLogger(CachingHttpFile.class);
    private final HttpFile file;
    private final int maxCachingLength;
    @Nullable
    private volatile AggregatedHttpFile cachedFile;

    CachingHttpFile(HttpFile file, int maxCachingLength) {
        this.file = Objects.requireNonNull(file, "file");
        this.maxCachingLength = maxCachingLength;
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return this.file.readAttributes(fileReadExecutor);
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return this.file.readHeaders(fileReadExecutor);
    }

    @Override
    public CompletableFuture<HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.getFile(fileReadExecutor).read(fileReadExecutor, alloc);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return this.getFile(fileReadExecutor).aggregate(fileReadExecutor);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.getFile(fileReadExecutor).aggregateWithPooledObjects(fileReadExecutor, alloc);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            try {
                return this.getFile(ctx.blockingTaskExecutor()).asService().serve(ctx, req);
            }
            catch (Exception e) {
                return (HttpResponse)Exceptions.throwUnsafely(e);
            }
        };
    }

    private HttpFile getFile(Executor fileReadExecutor) {
        Objects.requireNonNull(fileReadExecutor, "fileReadExecutor");
        return HttpFile.from(this.file.readAttributes(fileReadExecutor).thenApply(uncachedAttrs -> {
            if (uncachedAttrs == null) {
                this.cachedFile = null;
                return HttpFile.nonExistent();
            }
            if (uncachedAttrs.length() > (long)this.maxCachingLength) {
                this.cachedFile = null;
                return this.file;
            }
            AggregatedHttpFile cachedFile = this.cachedFile;
            if (cachedFile == null) {
                return this.cache(fileReadExecutor);
            }
            HttpFileAttributes cachedAttrs = cachedFile.attributes();
            assert (cachedAttrs != null);
            if (cachedAttrs.equals(uncachedAttrs)) {
                return cachedFile.toHttpFile();
            }
            this.cachedFile = null;
            return this.cache(fileReadExecutor);
        }));
    }

    private HttpFile cache(Executor fileReadExecutor) {
        return HttpFile.from(((CompletableFuture)this.file.aggregate(fileReadExecutor).thenApply(aggregated -> {
            this.cachedFile = aggregated;
            return aggregated.toHttpFile();
        })).exceptionally(cause -> {
            logger.warn("Failed to cache a file: {}", (Object)this.file, (Object)Exceptions.peel(cause));
            return this.file;
        }));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file", this.file).add("maxCachingLength", this.maxCachingLength).add("cachedFile", this.cachedFile).toString();
    }
}

