/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.common.encoding.StaticHttpDecodedResponse;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.file.AggregatedHttpFile;
import karate.com.linecorp.armeria.server.file.FileService;
import karate.com.linecorp.armeria.server.file.HttpFile;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.io.netty.buffer.ByteBufAllocator;

final class DecompressingHttpFile
implements HttpFile {
    private final HttpFile compressedFile;
    private final FileService.ContentEncoding encoding;
    @Nullable
    private final MediaType contentType;

    DecompressingHttpFile(HttpFile compressedFile, FileService.ContentEncoding encoding, @Nullable MediaType contentType) {
        this.compressedFile = compressedFile;
        this.encoding = encoding;
        this.contentType = contentType;
    }

    @Override
    public CompletableFuture<@Nullable HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return this.compressedFile.readAttributes(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return this.compressedFile.readHeaders(fileReadExecutor);
    }

    @Override
    public CompletableFuture<@Nullable HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.read(fileReadExecutor, alloc);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return this.compressedFile.aggregate(fileReadExecutor);
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return this.compressedFile.aggregateWithPooledObjects(fileReadExecutor, alloc);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            HttpResponse response = this.compressedFile.asService().serve(ctx, req);
            return new StaticHttpDecodedResponse(response, this.encoding.decoderFactory.newDecoder(ctx.alloc()), this.contentType);
        };
    }
}

