/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import karate.com.linecorp.armeria.common.HttpHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.Exceptions;
import karate.com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.com.linecorp.armeria.server.file.MediaTypeResolver;
import karate.com.linecorp.armeria.server.file.StreamingHttpFile;
import karate.io.netty.buffer.ByteBuf;

final class FileSystemHttpFile
extends StreamingHttpFile<ByteChannel> {
    private final Path path;

    FileSystemHttpFile(Path path, boolean contentTypeAutoDetectionEnabled, Clock clock, boolean dateEnabled, boolean lastModifiedEnabled, @Nullable BiFunction<String, HttpFileAttributes, String> entityTagFunction, HttpHeaders headers) {
        super(contentTypeAutoDetectionEnabled ? MediaTypeResolver.ofDefault().guessFromPath(path.toString(), null) : null, clock, dateEnabled, lastModifiedEnabled, entityTagFunction, headers);
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    protected String pathOrUri() {
        return this.path.toString();
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return null;
            }
            try {
                BasicFileAttributes attrs = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
                if (attrs.isRegularFile()) {
                    return new HttpFileAttributes(attrs.size(), attrs.lastModifiedTime().toMillis());
                }
            }
            catch (NoSuchFileException attrs) {
            }
            catch (IOException e) {
                return (HttpFileAttributes)Exceptions.throwUnsafely(e);
            }
            return null;
        }, fileReadExecutor);
    }

    @Override
    @Nullable
    protected ByteChannel newStream() throws IOException {
        try {
            return Files.newByteChannel(this.path, StandardOpenOption.READ);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    protected int read(ByteChannel src, ByteBuf dst) throws IOException {
        if (src instanceof ScatteringByteChannel) {
            return dst.writeBytes((ScatteringByteChannel)((Object)src), dst.writableBytes());
        }
        int readBytes = src.read(dst.nioBuffer(dst.writerIndex(), dst.writableBytes()));
        if (readBytes > 0) {
            dst.writerIndex(dst.writerIndex() + readBytes);
        }
        return readBytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("path", this.path).add("contentType", this.contentType()).add("dateEnabled", this.isDateEnabled()).add("lastModifiedEnabled", this.isLastModifiedEnabled()).add("additionalHeaders", this.additionalHeaders()).toString();
    }
}

