/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.file.AggregatedHttpFile;
import karate.com.linecorp.armeria.server.file.CachingHttpFile;
import karate.com.linecorp.armeria.server.file.DeferredHttpFile;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.com.linecorp.armeria.server.file.HttpFileBuilder;
import karate.com.linecorp.armeria.server.file.NonExistentHttpFile;
import karate.io.netty.buffer.ByteBufAllocator;

public interface HttpFile {
    public static HttpFile of(File file) {
        return HttpFile.builder(file).build();
    }

    public static HttpFile of(Path path) {
        return HttpFile.builder(path).build();
    }

    public static HttpFile of(ClassLoader classLoader, String path) {
        return HttpFile.builder(classLoader, path).build();
    }

    public static HttpFile of(HttpData data) {
        return HttpFile.builder(data).build();
    }

    public static HttpFile of(HttpData data, long lastModifiedMillis) {
        return HttpFile.builder(data, lastModifiedMillis).build();
    }

    public static HttpFile ofCached(HttpFile file, int maxCachingLength) {
        Objects.requireNonNull(file, "file");
        Preconditions.checkArgument(maxCachingLength >= 0, "maxCachingLength: %s (expected: >= 0)", maxCachingLength);
        if (maxCachingLength == 0) {
            return file;
        }
        return new CachingHttpFile(file, maxCachingLength);
    }

    public static HttpFile nonExistent() {
        return NonExistentHttpFile.INSTANCE;
    }

    public static HttpFile ofRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return new NonExistentHttpFile(location);
    }

    public static HttpFile from(CompletionStage<? extends HttpFile> stage) {
        return new DeferredHttpFile(Objects.requireNonNull(stage, "stage"));
    }

    public static HttpFileBuilder builder(File file) {
        return HttpFile.builder(Objects.requireNonNull(file, "file").toPath());
    }

    public static HttpFileBuilder builder(Path path) {
        return new HttpFileBuilder.FileSystemHttpFileBuilder(Objects.requireNonNull(path, "path"));
    }

    public static HttpFileBuilder builder(HttpData data) {
        return HttpFile.builder(data, System.currentTimeMillis());
    }

    public static HttpFileBuilder builder(HttpData data, long lastModifiedMillis) {
        Objects.requireNonNull(data, "data");
        return new HttpFileBuilder.HttpDataFileBuilder(data, lastModifiedMillis).autoDetectedContentType(false);
    }

    public static HttpFileBuilder builder(URL url) {
        Objects.requireNonNull(url, "url");
        if (url.getPath().endsWith("/")) {
            return new HttpFileBuilder.NonExistentHttpFileBuilder();
        }
        if ("file".equals(url.getProtocol())) {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException ignored) {
                f = new File(url.getPath());
            }
            return HttpFile.builder(f.toPath());
        }
        if ("jar".equals(url.getProtocol()) && (url.getPath().startsWith("file:") || url.getPath().startsWith("nested:")) || "jrt".equals(url.getProtocol()) || "bundle".equals(url.getProtocol())) {
            return new HttpFileBuilder.ClassPathHttpFileBuilder(url);
        }
        throw new IllegalArgumentException("Unsupported URL: " + url + " (must start with 'file:', 'jar:file', 'jar:nested', 'jrt:' or 'bundle:')");
    }

    public static HttpFileBuilder builder(ClassLoader classLoader, String path) {
        URL url;
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(path, "path");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((url = classLoader.getResource(path)) == null) {
            return new HttpFileBuilder.NonExistentHttpFileBuilder();
        }
        return HttpFile.builder(url);
    }

    public CompletableFuture<@Nullable HttpFileAttributes> readAttributes(Executor var1);

    public CompletableFuture<@Nullable ResponseHeaders> readHeaders(Executor var1);

    public CompletableFuture<@Nullable HttpResponse> read(Executor var1, ByteBufAllocator var2);

    public CompletableFuture<AggregatedHttpFile> aggregate(Executor var1);

    @UnstableApi
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor var1, ByteBufAllocator var2);

    public HttpService asService();
}

