/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.file;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.ResponseHeaders;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.file.AggregatedHttpFile;
import karate.com.linecorp.armeria.server.file.HttpFile;
import karate.com.linecorp.armeria.server.file.HttpFileAttributes;
import karate.com.linecorp.armeria.server.file.NonExistentAggregatedHttpFile;
import karate.io.netty.buffer.ByteBufAllocator;

final class NonExistentHttpFile
implements HttpFile {
    static final NonExistentHttpFile INSTANCE = new NonExistentHttpFile(null);
    private static final CompletableFuture<AggregatedHttpFile> AGGREGATED_FUTURE = UnmodifiableFuture.completedFuture(NonExistentAggregatedHttpFile.INSTANCE);
    @Nullable
    private final String location;

    NonExistentHttpFile(@Nullable String location) {
        this.location = location;
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            switch (req.method()) {
                case HEAD: 
                case GET: {
                    if (this.location == null) {
                        return HttpResponse.of(HttpStatus.NOT_FOUND);
                    }
                    return HttpResponse.ofRedirect(this.location);
                }
            }
            return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
        };
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return AGGREGATED_FUTURE;
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return AGGREGATED_FUTURE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

