/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.healthcheck;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.DoubleSupplier;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.server.healthcheck.HealthChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CpuHealthChecker
implements HealthChecker {
    private static final Logger logger = LoggerFactory.getLogger(CpuHealthChecker.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final DoubleSupplier currentSystemCpuUsageSupplier;
    private static final DoubleSupplier currentProcessCpuUsageSupplier;
    @Nullable
    private static final OperatingSystemMXBean operatingSystemBean;
    @Nullable
    private static final Class<?> operatingSystemBeanClass;
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES;
    @Nullable
    private static final MethodHandle systemCpuLoad;
    @Nullable
    private static final MethodHandle processCpuLoad;
    private final DoubleSupplier systemCpuUsageSupplier;
    private final DoubleSupplier processCpuUsageSupplier;
    final double targetProcessCpuLoad;
    final double targetSystemCpuUsage;

    CpuHealthChecker(double targetSystemCpuUsage, double targetProcessCpuUsage) {
        this(targetSystemCpuUsage, targetProcessCpuUsage, currentSystemCpuUsageSupplier, currentProcessCpuUsageSupplier);
    }

    private CpuHealthChecker(double targetSystemCpuUsage, double targetProcessCpuLoad, DoubleSupplier systemCpuUsageSupplier, DoubleSupplier processCpuUsageSupplier) {
        Preconditions.checkArgument(targetSystemCpuUsage >= 0.0 && targetSystemCpuUsage <= 1.0, "cpuUsage: %s (expected: 0 <= cpuUsage <= 1)", (Object)targetSystemCpuUsage);
        Preconditions.checkArgument(targetProcessCpuLoad >= 0.0 && targetProcessCpuLoad <= 1.0, "processCpuLoad: %s (expected: 0 <= processCpuLoad <= 1)", (Object)targetProcessCpuLoad);
        this.targetSystemCpuUsage = targetSystemCpuUsage;
        this.targetProcessCpuLoad = targetProcessCpuLoad;
        this.systemCpuUsageSupplier = systemCpuUsageSupplier;
        this.processCpuUsageSupplier = processCpuUsageSupplier;
        Preconditions.checkState(operatingSystemBeanClass != null, "Unable to find an 'OperatingSystemMXBean' class");
        Preconditions.checkState(operatingSystemBean != null, "Unable to find an 'OperatingSystemMXBean'");
        Preconditions.checkState(systemCpuLoad != null, "Unable to find the method 'OperatingSystemMXBean.getCpuLoad' or 'OperatingSystemMXBean.getSystemCpuLoad'");
        Preconditions.checkState(processCpuLoad != null, "Unable to find the method 'OperatingSystemMXBean.getProcessCpuLoad'");
    }

    private static double invoke(@Nullable MethodHandle mh) {
        if (mh == null) {
            return Double.NaN;
        }
        try {
            return mh.invoke(operatingSystemBean);
        }
        catch (Throwable e) {
            return Double.NaN;
        }
    }

    @Nullable
    private static MethodHandle detectMethod(String name) {
        if (operatingSystemBeanClass == null) {
            return null;
        }
        try {
            operatingSystemBeanClass.cast(operatingSystemBean);
            Method method = operatingSystemBeanClass.getMethod(name, new Class[0]);
            return LOOKUP.unreflect(method);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | SecurityException e) {
            logger.warn("Failed to detect method {}.{} for {}", new Object[]{operatingSystemBeanClass.getSimpleName(), name, CpuHealthChecker.class.getSimpleName(), e});
            return null;
        }
    }

    @Nullable
    private static Class<?> getFirstClassFound(List<String> classNames) {
        for (String className : classNames) {
            try {
                return Class.forName(className, false, CpuHealthChecker.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy(this.systemCpuUsageSupplier, this.processCpuUsageSupplier);
    }

    private boolean isHealthy(DoubleSupplier currentSystemCpuUsageSupplier, DoubleSupplier currentProcessCpuUsageSupplier) {
        double currentSystemCpuUsage = currentSystemCpuUsageSupplier.getAsDouble();
        double currentProcessCpuUsage = currentProcessCpuUsageSupplier.getAsDouble();
        return currentSystemCpuUsage <= this.targetSystemCpuUsage && currentProcessCpuUsage <= this.targetProcessCpuLoad;
    }

    static {
        OPERATING_SYSTEM_BEAN_CLASS_NAMES = ImmutableList.of("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
        operatingSystemBeanClass = CpuHealthChecker.getFirstClassFound(OPERATING_SYSTEM_BEAN_CLASS_NAMES);
        operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
        MethodHandle getCpuLoad = CpuHealthChecker.detectMethod("getCpuLoad");
        systemCpuLoad = getCpuLoad != null ? getCpuLoad : CpuHealthChecker.detectMethod("getSystemCpuLoad");
        processCpuLoad = CpuHealthChecker.detectMethod("getProcessCpuLoad");
        currentSystemCpuUsageSupplier = () -> CpuHealthChecker.invoke(systemCpuLoad);
        currentProcessCpuUsageSupplier = () -> CpuHealthChecker.invoke(processCpuLoad);
    }
}

