/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.healthcheck;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import karate.com.fasterxml.jackson.databind.JsonNode;
import karate.com.fasterxml.jackson.databind.ObjectMapper;
import karate.com.fasterxml.jackson.databind.node.JsonNodeType;
import karate.com.linecorp.armeria.common.AggregatedHttpRequest;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckUpdateHandler;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckUpdateResult;

enum DefaultHealthCheckUpdateHandler implements HealthCheckUpdateHandler
{
    INSTANCE;

    private static final ObjectMapper mapper;

    @Override
    public CompletionStage<HealthCheckUpdateResult> handle(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Objects.requireNonNull(req, "req");
        switch (req.method()) {
            case PUT: 
            case POST: {
                return req.aggregate().thenApply(DefaultHealthCheckUpdateHandler::handlePut);
            }
            case PATCH: {
                return req.aggregate().thenApply(DefaultHealthCheckUpdateHandler::handlePatch);
            }
        }
        return UnmodifiableFuture.exceptionallyCompletedFuture(HttpStatusException.of(HttpStatus.METHOD_NOT_ALLOWED));
    }

    private static HealthCheckUpdateResult handlePut(AggregatedHttpRequest req) {
        JsonNode json = DefaultHealthCheckUpdateHandler.toJsonNode(req);
        if (json.getNodeType() != JsonNodeType.OBJECT) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        JsonNode healthy = json.get("healthy");
        if (healthy == null) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        if (healthy.getNodeType() != JsonNodeType.BOOLEAN) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        return healthy.booleanValue() ? HealthCheckUpdateResult.HEALTHY : HealthCheckUpdateResult.UNHEALTHY;
    }

    private static HealthCheckUpdateResult handlePatch(AggregatedHttpRequest req) {
        JsonNode json = DefaultHealthCheckUpdateHandler.toJsonNode(req);
        if (json.getNodeType() != JsonNodeType.ARRAY || json.size() != 1) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        JsonNode patchCommand = json.get(0);
        JsonNode op = patchCommand.get("op");
        JsonNode path = patchCommand.get("path");
        JsonNode value = patchCommand.get("value");
        if (!(op != null && path != null && value != null && "replace".equals(op.textValue()) && "/healthy".equals(path.textValue()) && value.isBoolean())) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
        return value.booleanValue() ? HealthCheckUpdateResult.HEALTHY : HealthCheckUpdateResult.UNHEALTHY;
    }

    private static JsonNode toJsonNode(AggregatedHttpRequest req) {
        MediaType contentType = req.contentType();
        if (contentType != null && !contentType.is(MediaType.JSON)) {
            throw HttpStatusException.of(HttpStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        Charset charset = contentType == null ? StandardCharsets.UTF_8 : contentType.charset(StandardCharsets.UTF_8);
        try {
            return StandardCharsets.UTF_8.equals(charset) ? mapper.readTree(req.content().array()) : mapper.readTree(req.content(charset));
        }
        catch (IOException e) {
            throw HttpStatusException.of(HttpStatus.BAD_REQUEST);
        }
    }

    static {
        mapper = new ObjectMapper();
    }
}

