/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.healthcheck;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import karate.com.linecorp.armeria.common.AggregatedHttpResponse;
import karate.com.linecorp.armeria.common.HttpData;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.server.TransientServiceOptionsBuilder;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import karate.com.linecorp.armeria.server.TransientServiceBuilder;
import karate.com.linecorp.armeria.server.TransientServiceOption;
import karate.com.linecorp.armeria.server.healthcheck.DefaultHealthCheckUpdateHandler;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckService;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckUpdateHandler;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckUpdateListener;
import karate.com.linecorp.armeria.server.healthcheck.HealthChecker;

public final class HealthCheckServiceBuilder
implements TransientServiceBuilder {
    private static final int DEFAULT_LONG_POLLING_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_PING_INTERVAL_SECONDS = 5;
    private static final double DEFAULT_LONG_POLLING_TIMEOUT_JITTER_RATE = 0.2;
    private final ImmutableSet.Builder<HealthChecker> healthCheckers = ImmutableSet.builder();
    private AggregatedHttpResponse healthyResponse = AggregatedHttpResponse.of(HttpStatus.OK, MediaType.JSON_UTF_8, "{\"healthy\":true}");
    private AggregatedHttpResponse unhealthyResponse = AggregatedHttpResponse.of(HttpStatus.SERVICE_UNAVAILABLE, MediaType.JSON_UTF_8, "{\"healthy\":false}");
    private long maxLongPollingTimeoutMillis = TimeUnit.SECONDS.toMillis(60L);
    private double longPollingTimeoutJitterRate = 0.2;
    private long pingIntervalMillis = TimeUnit.SECONDS.toMillis(5L);
    @Nullable
    private HealthCheckUpdateHandler updateHandler;
    private final ImmutableList.Builder<HealthCheckUpdateListener> updateListenersBuilder = ImmutableList.builder();
    private boolean startHealthy = true;
    private final TransientServiceOptionsBuilder transientServiceOptionsBuilder = new TransientServiceOptionsBuilder();

    HealthCheckServiceBuilder() {
    }

    public HealthCheckServiceBuilder checkers(HealthChecker ... healthCheckers) {
        return this.checkers(ImmutableSet.copyOf(Objects.requireNonNull(healthCheckers, "healthCheckers")));
    }

    public HealthCheckServiceBuilder checkers(Iterable<? extends HealthChecker> healthCheckers) {
        this.healthCheckers.addAll(Objects.requireNonNull(healthCheckers, "healthCheckers"));
        return this;
    }

    public HealthCheckServiceBuilder healthyResponse(AggregatedHttpResponse healthyResponse) {
        Objects.requireNonNull(healthyResponse, "healthyResponse");
        this.healthyResponse = HealthCheckServiceBuilder.copyResponse(healthyResponse);
        return this;
    }

    public HealthCheckServiceBuilder unhealthyResponse(AggregatedHttpResponse unhealthyResponse) {
        Objects.requireNonNull(unhealthyResponse, "unhealthyResponse");
        this.unhealthyResponse = HealthCheckServiceBuilder.copyResponse(unhealthyResponse);
        return this;
    }

    private static AggregatedHttpResponse copyResponse(AggregatedHttpResponse res) {
        return AggregatedHttpResponse.of(res.informationals(), res.headers(), HttpData.copyOf(res.content().array()), res.trailers());
    }

    public HealthCheckServiceBuilder longPolling(Duration maxLongPollingTimeout) {
        return this.longPolling(maxLongPollingTimeout, this.longPollingTimeoutJitterRate, Duration.ofMillis(this.pingIntervalMillis));
    }

    public HealthCheckServiceBuilder longPolling(long maxLongPollingTimeoutMillis) {
        return this.longPolling(maxLongPollingTimeoutMillis, this.longPollingTimeoutJitterRate, this.pingIntervalMillis);
    }

    public HealthCheckServiceBuilder longPolling(Duration maxLongPollingTimeout, double longPollingTimeoutJitterRate, Duration pingInterval) {
        Objects.requireNonNull(maxLongPollingTimeout, "maxLongPollingTimeout");
        Preconditions.checkArgument(!maxLongPollingTimeout.isNegative(), "maxLongPollingTimeout: %s (expected: >= 0)", (Object)maxLongPollingTimeout);
        Objects.requireNonNull(pingInterval, "pingInterval");
        Preconditions.checkArgument(!pingInterval.isNegative(), "pingInterval: %s (expected: >= 0)", (Object)pingInterval);
        return this.longPolling(maxLongPollingTimeout.toMillis(), longPollingTimeoutJitterRate, pingInterval.toMillis());
    }

    public HealthCheckServiceBuilder longPolling(long maxLongPollingTimeoutMillis, double longPollingTimeoutJitterRate, long pingIntervalMillis) {
        Preconditions.checkArgument(maxLongPollingTimeoutMillis >= 0L, "maxLongPollingTimeoutMillis: %s (expected: >= 0)", maxLongPollingTimeoutMillis);
        Preconditions.checkArgument(pingIntervalMillis >= 0L, "pingIntervalMillis: %s (expected: >= 0)", pingIntervalMillis);
        Preconditions.checkArgument(longPollingTimeoutJitterRate >= 0.0 && longPollingTimeoutJitterRate <= 1.0, "longPollingTimeoutJitterRate: %s (expected: >= 0 && <= 1)", (Object)longPollingTimeoutJitterRate);
        this.maxLongPollingTimeoutMillis = maxLongPollingTimeoutMillis;
        this.longPollingTimeoutJitterRate = longPollingTimeoutJitterRate;
        this.pingIntervalMillis = pingIntervalMillis;
        return this;
    }

    public HealthCheckServiceBuilder updatable(boolean updatable) {
        if (updatable) {
            return this.updatable(DefaultHealthCheckUpdateHandler.INSTANCE);
        }
        this.updateHandler = null;
        return this;
    }

    public HealthCheckServiceBuilder updatable(HealthCheckUpdateHandler updateHandler) {
        this.updateHandler = Objects.requireNonNull(updateHandler, "updateHandler");
        return this;
    }

    public HealthCheckServiceBuilder updateListener(HealthCheckUpdateListener updateListener) {
        this.updateListenersBuilder.add((Object)Objects.requireNonNull(updateListener, "updateListener"));
        return this;
    }

    public HealthCheckServiceBuilder startUnhealthy() {
        this.startHealthy = false;
        return this;
    }

    @Override
    public HealthCheckServiceBuilder transientServiceOptions(TransientServiceOption ... transientServiceOptions) {
        this.transientServiceOptionsBuilder.transientServiceOptions(transientServiceOptions);
        return this;
    }

    @Override
    public HealthCheckServiceBuilder transientServiceOptions(Iterable<TransientServiceOption> transientServiceOptions) {
        this.transientServiceOptionsBuilder.transientServiceOptions((Iterable)transientServiceOptions);
        return this;
    }

    public HealthCheckService build() {
        Preconditions.checkState(this.startHealthy || this.updateHandler != null, "Healthiness must be updatable by server listener or update handler.");
        return new HealthCheckService((Set<HealthChecker>)((Object)this.healthCheckers.build()), this.healthyResponse, this.unhealthyResponse, this.maxLongPollingTimeoutMillis, this.longPollingTimeoutJitterRate, this.pingIntervalMillis, this.updateHandler, (List<HealthCheckUpdateListener>)((Object)this.updateListenersBuilder.build()), this.startHealthy, this.transientServiceOptionsBuilder.build());
    }
}

