/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.healthcheck;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import karate.com.linecorp.armeria.common.CommonPools;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.healthcheck.CpuHealthChecker;
import karate.com.linecorp.armeria.server.healthcheck.HealthCheckStatus;
import karate.com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import karate.com.linecorp.armeria.server.healthcheck.ScheduledHealthChecker;
import karate.io.netty.util.concurrent.EventExecutor;

@FunctionalInterface
public interface HealthChecker {
    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl) {
        return HealthChecker.of(healthChecker, fallbackTtl, CommonPools.workerGroup().next());
    }

    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl, EventExecutor eventExecutor) {
        Objects.requireNonNull(fallbackTtl, "fallbackTtl");
        Preconditions.checkArgument(!fallbackTtl.isNegative() && !fallbackTtl.isZero(), "fallbackTtl: %s (expected: > 0)", (Object)fallbackTtl);
        return new ScheduledHealthChecker(Objects.requireNonNull(healthChecker, "healthChecker"), fallbackTtl, Objects.requireNonNull(eventExecutor, "eventExecutor"));
    }

    public static HealthChecker ofCpu(double targetSystemCpuUsage, double targetProcessCpuUsage) {
        return new CpuHealthChecker(targetSystemCpuUsage, targetProcessCpuUsage);
    }

    public boolean isHealthy();
}

