/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.logging;

import java.util.Map;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;

enum AccessLogType {
    LOCAL_IP_ADDRESS('A', false, VariableRequirement.NO),
    REMOTE_IP_ADDRESS('a', false, VariableRequirement.OPTIONAL),
    REMOTE_HOST('h', false, VariableRequirement.NO),
    RFC931('l', false, VariableRequirement.NO),
    AUTHENTICATED_USER('u', false, VariableRequirement.NO),
    REQUEST_TIMESTAMP('t', false, VariableRequirement.OPTIONAL),
    REQUEST_LINE('r', true, VariableRequirement.NO),
    RESPONSE_STATUS_CODE('s', false, VariableRequirement.NO),
    RESPONSE_LENGTH('b', true, VariableRequirement.NO),
    REQUEST_HEADER('i', true, VariableRequirement.YES),
    RESPONSE_HEADER('o', true, VariableRequirement.YES),
    ATTRIBUTE('j', true, VariableRequirement.YES),
    REQUEST_LOG('L', true, VariableRequirement.YES),
    TEXT('%', false, VariableRequirement.NO),
    REQUEST_ID('I', false, VariableRequirement.OPTIONAL);

    private static final Map<Character, AccessLogType> tokenToEnum;
    private final char token;
    private final boolean isConditionAvailable;
    private final VariableRequirement variableRequirement;

    @Nullable
    static AccessLogType find(char token) {
        return tokenToEnum.get(Character.valueOf(token));
    }

    private AccessLogType(char token, boolean isConditionAvailable, VariableRequirement variableRequirement) {
        this.token = token;
        this.isConditionAvailable = isConditionAvailable;
        this.variableRequirement = variableRequirement;
    }

    char token() {
        return this.token;
    }

    boolean isConditionAvailable() {
        return this.isConditionAvailable;
    }

    VariableRequirement variableRequirement() {
        return this.variableRequirement;
    }

    static {
        ImmutableMap.Builder<Character, AccessLogType> builder = ImmutableMap.builder();
        for (AccessLogType k : AccessLogType.values()) {
            builder.put(Character.valueOf(k.token), k);
        }
        tokenToEnum = builder.build();
    }

    static enum VariableRequirement {
        YES,
        NO,
        OPTIONAL;

    }
}

