/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.logging;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import karate.com.linecorp.armeria.common.logging.RequestLog;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.server.logging.AccessLogComponent;
import karate.com.linecorp.armeria.server.logging.AccessLogFormats;
import karate.com.linecorp.armeria.server.logging.AccessLogger;

@FunctionalInterface
public interface AccessLogWriter {
    public static AccessLogWriter common() {
        return requestLog -> AccessLogger.write(AccessLogFormats.COMMON, requestLog);
    }

    public static AccessLogWriter combined() {
        return requestLog -> AccessLogger.write(AccessLogFormats.COMBINED, requestLog);
    }

    public static AccessLogWriter disabled() {
        return requestLog -> {};
    }

    public static AccessLogWriter custom(String formatStr) {
        Objects.requireNonNull(formatStr, "formatStr");
        List<AccessLogComponent> accessLogFormat = AccessLogFormats.parseCustom(formatStr);
        Preconditions.checkArgument(!accessLogFormat.isEmpty(), "Invalid access log format string: %s", (Object)formatStr);
        return requestLog -> AccessLogger.write(accessLogFormat, requestLog);
    }

    public void log(RequestLog var1);

    default public AccessLogWriter andThen(final AccessLogWriter after) {
        Objects.requireNonNull(after, "after");
        return new AccessLogWriter(){

            @Override
            public void log(RequestLog log) {
                try {
                    AccessLogWriter.this.log(log);
                }
                finally {
                    after.log(log);
                }
            }

            @Override
            public CompletableFuture<Void> shutdown() {
                CompletableFuture<Void> f2;
                CompletableFuture<Void> f1;
                try {
                    f1 = AccessLogWriter.this.shutdown();
                }
                finally {
                    f2 = after.shutdown();
                }
                return CompletableFuture.allOf(f1, f2);
            }
        };
    }

    default public CompletableFuture<Void> shutdown() {
        return UnmodifiableFuture.completedFuture(null);
    }
}

