/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.management;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.stream.Collectors;
import karate.com.linecorp.armeria.common.ExchangeType;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.MediaType;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.RoutingContext;
import karate.com.linecorp.armeria.server.ServiceRequestContext;

enum ThreadDumpService implements HttpService
{
    INSTANCE;


    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        boolean acceptJson = req.headers().accept().stream().anyMatch(MediaType.JSON::is);
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        if (acceptJson) {
            return HttpResponse.ofJson(threadInfos);
        }
        String threadDump = Arrays.stream(threadInfos).map(ThreadInfo::toString).collect(Collectors.joining());
        return HttpResponse.of(HttpStatus.OK, MediaType.PLAIN_TEXT, threadDump);
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.UNARY;
    }
}

