/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.observation;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.logging.RequestLogProperty;
import karate.com.linecorp.armeria.internal.common.RequestContextExtension;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.Service;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.SimpleDecoratingHttpService;
import karate.com.linecorp.armeria.server.TransientServiceOption;
import karate.com.linecorp.armeria.server.observation.DefaultServiceObservationConvention;
import karate.com.linecorp.armeria.server.observation.HttpServiceObservationDocumentation;
import karate.com.linecorp.armeria.server.observation.ServiceObservationContext;
import karate.io.micrometer.observation.Observation;
import karate.io.micrometer.observation.ObservationConvention;
import karate.io.micrometer.observation.ObservationRegistry;

@UnstableApi
public final class ObservationService
extends SimpleDecoratingHttpService {
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ObservationConvention<ServiceObservationContext> observationConvention;

    public static Function<? super HttpService, ObservationService> newDecorator(ObservationRegistry observationRegistry) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        return service -> new ObservationService((HttpService)service, observationRegistry, null);
    }

    public static Function<? super HttpService, ObservationService> newDecorator(ObservationRegistry observationRegistry, ObservationConvention<ServiceObservationContext> observationConvention) {
        Objects.requireNonNull(observationRegistry, "observationRegistry");
        Objects.requireNonNull(observationConvention, "observationConvention");
        return service -> new ObservationService((HttpService)service, observationRegistry, observationConvention);
    }

    private ObservationService(HttpService delegate, ObservationRegistry observationRegistry, @Nullable ObservationConvention<ServiceObservationContext> observationConvention) {
        super(delegate);
        this.observationRegistry = Objects.requireNonNull(observationRegistry, "observationRegistry");
        this.observationConvention = observationConvention;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Set<TransientServiceOption> transientServiceOptions = ctx.config().transientServiceOptions();
        if (!transientServiceOptions.contains((Object)TransientServiceOption.WITH_TRACING) || !transientServiceOptions.contains((Object)TransientServiceOption.WITH_METRIC_COLLECTION)) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        ServiceObservationContext serviceObservationContext = new ServiceObservationContext(ctx, req);
        Observation observation = HttpServiceObservationDocumentation.OBSERVATION.observation(this.observationConvention, DefaultServiceObservationConvention.INSTANCE, () -> serviceObservationContext, this.observationRegistry).start();
        RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
        if (this.observationRegistry.isNoop() || observation.isNoop()) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        if (ctxExtension != null) {
            ctxExtension.hook(observation::openScope);
        }
        ObservationService.enrichObservation(ctx, serviceObservationContext, observation);
        return observation.scopedChecked(() -> (HttpResponse)((Service)this.unwrap()).serve(ctx, req));
    }

    private static void enrichObservation(ServiceRequestContext ctx, ServiceObservationContext serviceObservationContext, Observation observation) {
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> observation.event(HttpServiceObservationDocumentation.Events.WIRE_RECEIVE));
        ctx.log().whenAvailable(RequestLogProperty.RESPONSE_FIRST_BYTES_TRANSFERRED_TIME).thenAccept(requestLog -> {
            if (requestLog.responseFirstBytesTransferredTimeNanos() != null) {
                observation.event(HttpServiceObservationDocumentation.Events.WIRE_SEND);
            }
        });
        ctx.log().whenComplete().thenAccept(requestLog -> {
            serviceObservationContext.setResponse(requestLog);
            observation.stop();
        });
    }
}

