/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.throttling;

import java.util.Objects;
import karate.com.linecorp.armeria.common.Request;
import karate.com.linecorp.armeria.common.Response;
import karate.com.linecorp.armeria.server.Service;
import karate.com.linecorp.armeria.server.throttling.ThrottlingAcceptHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingStrategy;

abstract class AbstractThrottlingServiceBuilder<I extends Request, O extends Response> {
    private final ThrottlingStrategy<I> strategy;
    private ThrottlingAcceptHandler<I, O> acceptHandler;
    private ThrottlingRejectHandler<I, O> rejectHandler;

    AbstractThrottlingServiceBuilder(ThrottlingStrategy<I> strategy, ThrottlingRejectHandler<I, O> defaultRejectHandler) {
        this.strategy = Objects.requireNonNull(strategy, "strategy");
        this.acceptHandler = Service::serve;
        this.rejectHandler = Objects.requireNonNull(defaultRejectHandler, "defaultRejectHandler");
    }

    final ThrottlingStrategy<I> getStrategy() {
        return this.strategy;
    }

    final void setAcceptHandler(ThrottlingAcceptHandler<I, O> acceptHandler) {
        this.acceptHandler = Objects.requireNonNull(acceptHandler, "acceptHandler");
    }

    final ThrottlingAcceptHandler<I, O> getAcceptHandler() {
        return this.acceptHandler;
    }

    final void setRejectHandler(ThrottlingRejectHandler<I, O> rejectHandler) {
        this.rejectHandler = Objects.requireNonNull(rejectHandler, "rejectHandler");
    }

    final ThrottlingRejectHandler<I, O> getRejectHandler() {
        return this.rejectHandler;
    }
}

