/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.throttling;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import karate.com.linecorp.armeria.common.Request;
import karate.com.linecorp.armeria.common.annotation.Nullable;
import karate.com.linecorp.armeria.common.util.UnmodifiableFuture;
import karate.com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import karate.com.linecorp.armeria.internal.shaded.guava.util.concurrent.RateLimiter;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.throttling.ThrottlingStrategy;

final class RateLimitingThrottlingStrategy<T extends Request>
extends ThrottlingStrategy<T> {
    private final RateLimiter rateLimiter;

    RateLimitingThrottlingStrategy(double requestPerSecond, @Nullable String name) {
        super(name);
        Preconditions.checkArgument(requestPerSecond > 0.0, "requestPerSecond: %s (expected: > 0)", (Object)requestPerSecond);
        this.rateLimiter = RateLimiter.create(requestPerSecond);
    }

    RateLimitingThrottlingStrategy(double requestPerSecond) {
        this(requestPerSecond, null);
    }

    RateLimitingThrottlingStrategy(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter, "rateLimiter");
    }

    @Override
    public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
        return UnmodifiableFuture.completedFuture(this.rateLimiter.tryAcquire());
    }
}

