/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.throttling;

import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.common.RpcRequest;
import karate.com.linecorp.armeria.common.RpcResponse;
import karate.com.linecorp.armeria.server.HttpStatusException;
import karate.com.linecorp.armeria.server.RpcService;
import karate.com.linecorp.armeria.server.throttling.AbstractThrottlingServiceBuilder;
import karate.com.linecorp.armeria.server.throttling.ThrottlingAcceptHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingRpcService;
import karate.com.linecorp.armeria.server.throttling.ThrottlingStrategy;

public final class ThrottlingRpcServiceBuilder
extends AbstractThrottlingServiceBuilder<RpcRequest, RpcResponse> {
    private static final ThrottlingRejectHandler<RpcRequest, RpcResponse> DEFAULT_REJECT_HANDLER = (delegate, ctx, req, cause) -> RpcResponse.ofFailure(HttpStatusException.of(HttpStatus.SERVICE_UNAVAILABLE));

    ThrottlingRpcServiceBuilder(ThrottlingStrategy<RpcRequest> strategy) {
        super(strategy, DEFAULT_REJECT_HANDLER);
    }

    public ThrottlingRpcServiceBuilder onAcceptedRequest(ThrottlingAcceptHandler<RpcRequest, RpcResponse> acceptHandler) {
        this.setAcceptHandler(acceptHandler);
        return this;
    }

    public ThrottlingRpcServiceBuilder onRejectedRequest(ThrottlingRejectHandler<RpcRequest, RpcResponse> rejectHandler) {
        this.setRejectHandler(rejectHandler);
        return this;
    }

    public ThrottlingRpcService build(RpcService delegate) {
        return new ThrottlingRpcService(Objects.requireNonNull(delegate, "delegate"), this.getStrategy(), this.getAcceptHandler(), this.getRejectHandler());
    }

    public Function<? super RpcService, ThrottlingRpcService> newDecorator() {
        ThrottlingStrategy strategy = this.getStrategy();
        ThrottlingAcceptHandler acceptHandler = this.getAcceptHandler();
        ThrottlingRejectHandler rejectHandler = this.getRejectHandler();
        return service -> new ThrottlingRpcService((RpcService)service, strategy, acceptHandler, rejectHandler);
    }
}

