/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.throttling;

import java.util.Objects;
import java.util.function.Function;
import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.HttpStatus;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.throttling.AbstractThrottlingServiceBuilder;
import karate.com.linecorp.armeria.server.throttling.ThrottlingAcceptHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import karate.com.linecorp.armeria.server.throttling.ThrottlingService;
import karate.com.linecorp.armeria.server.throttling.ThrottlingStrategy;

public final class ThrottlingServiceBuilder
extends AbstractThrottlingServiceBuilder<HttpRequest, HttpResponse> {
    private static final ThrottlingRejectHandler<HttpRequest, HttpResponse> DEFAULT_REJECT_HANDLER = (delegate, ctx, req, cause) -> HttpResponse.of(HttpStatus.TOO_MANY_REQUESTS);

    ThrottlingServiceBuilder(ThrottlingStrategy<HttpRequest> strategy) {
        super(strategy, DEFAULT_REJECT_HANDLER);
    }

    public ThrottlingServiceBuilder onAcceptedRequest(ThrottlingAcceptHandler<HttpRequest, HttpResponse> acceptHandler) {
        this.setAcceptHandler(acceptHandler);
        return this;
    }

    public ThrottlingServiceBuilder onRejectedRequest(ThrottlingRejectHandler<HttpRequest, HttpResponse> rejectHandler) {
        this.setRejectHandler(rejectHandler);
        return this;
    }

    public ThrottlingService build(HttpService delegate) {
        return new ThrottlingService(Objects.requireNonNull(delegate, "delegate"), this.getStrategy(), this.getAcceptHandler(), this.getRejectHandler());
    }

    public Function<? super HttpService, ThrottlingService> newDecorator() {
        ThrottlingStrategy strategy = this.getStrategy();
        ThrottlingAcceptHandler acceptHandler = this.getAcceptHandler();
        ThrottlingRejectHandler rejectHandler = this.getRejectHandler();
        return service -> new ThrottlingService((HttpService)service, strategy, acceptHandler, rejectHandler);
    }
}

