/*
 * Decompiled with CFR 0.152.
 */
package karate.com.linecorp.armeria.server.websocket;

import karate.com.linecorp.armeria.common.HttpRequest;
import karate.com.linecorp.armeria.common.HttpResponse;
import karate.com.linecorp.armeria.common.annotation.UnstableApi;
import karate.com.linecorp.armeria.common.websocket.WebSocket;
import karate.com.linecorp.armeria.server.HttpService;
import karate.com.linecorp.armeria.server.ServiceOptions;
import karate.com.linecorp.armeria.server.ServiceRequestContext;
import karate.com.linecorp.armeria.server.websocket.WebSocketProtocolHandler;
import karate.com.linecorp.armeria.server.websocket.WebSocketServiceBuilder;
import karate.com.linecorp.armeria.server.websocket.WebSocketServiceHandler;
import karate.com.linecorp.armeria.server.websocket.WebSocketUpgradeResult;

@UnstableApi
public interface WebSocketService
extends HttpService {
    public static WebSocketService of(WebSocketServiceHandler handler) {
        return new WebSocketServiceBuilder(handler).build();
    }

    public static WebSocketServiceBuilder builder(WebSocketServiceHandler handler) {
        return new WebSocketServiceBuilder(handler);
    }

    @Override
    default public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        WebSocketUpgradeResult upgradeResult = this.protocolHandler().upgrade(ctx, req);
        if (!upgradeResult.isSuccess()) {
            return upgradeResult.fallbackResponse();
        }
        WebSocket in = this.protocolHandler().decode(ctx, req);
        WebSocket out = this.serve(ctx, in);
        return this.protocolHandler().encode(ctx, out);
    }

    @Override
    public WebSocket serve(ServiceRequestContext var1, WebSocket var2) throws Exception;

    public WebSocketProtocolHandler protocolHandler();

    @Override
    default public ServiceOptions options() {
        return WebSocketServiceBuilder.DEFAULT_OPTIONS;
    }
}

