/*
 * Decompiled with CFR 0.152.
 */
package karate.io.micrometer.core.instrument.binder.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import karate.io.micrometer.common.lang.Nullable;
import karate.io.micrometer.common.util.StringUtils;
import karate.io.micrometer.core.annotation.Incubating;
import karate.io.micrometer.core.instrument.Tag;
import karate.io.micrometer.core.instrument.binder.http.Outcome;

@Incubating(since="1.12.0")
public class HttpJakartaServletRequestTags {
    private static final Tag EXCEPTION_NONE = Tag.of("exception", "None");
    private static final Tag STATUS_UNKNOWN = Tag.of("status", "UNKNOWN");
    private static final Tag METHOD_UNKNOWN = Tag.of("method", "UNKNOWN");

    private HttpJakartaServletRequestTags() {
    }

    public static Tag method(@Nullable HttpServletRequest request) {
        return request != null ? Tag.of("method", request.getMethod()) : METHOD_UNKNOWN;
    }

    public static Tag status(@Nullable HttpServletResponse response) {
        return response != null ? Tag.of("status", Integer.toString(response.getStatus())) : STATUS_UNKNOWN;
    }

    public static Tag exception(@Nullable Throwable exception) {
        if (exception != null) {
            String simpleName = exception.getClass().getSimpleName();
            return Tag.of("exception", StringUtils.isNotBlank(simpleName) ? simpleName : exception.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    public static Tag outcome(@Nullable HttpServletResponse response) {
        Outcome outcome = response != null ? Outcome.forStatus(response.getStatus()) : Outcome.UNKNOWN;
        return outcome.asTag();
    }
}

