/*
 * Decompiled with CFR 0.152.
 */
package karate.io.micrometer.core.instrument.binder.mongodb;

import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.concurrent.TimeUnit;
import karate.io.micrometer.common.lang.NonNullApi;
import karate.io.micrometer.common.lang.NonNullFields;
import karate.io.micrometer.core.annotation.Incubating;
import karate.io.micrometer.core.instrument.MeterRegistry;
import karate.io.micrometer.core.instrument.Timer;
import karate.io.micrometer.core.instrument.binder.mongodb.DefaultMongoCommandTagsProvider;
import karate.io.micrometer.core.instrument.binder.mongodb.MongoCommandTagsProvider;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsCommandListener
implements CommandListener {
    private final MeterRegistry registry;
    private final MongoCommandTagsProvider tagsProvider;

    public MongoMetricsCommandListener(MeterRegistry registry) {
        this(registry, new DefaultMongoCommandTagsProvider());
    }

    public MongoMetricsCommandListener(MeterRegistry registry, MongoCommandTagsProvider tagsProvider) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
    }

    public void commandStarted(CommandStartedEvent commandStartedEvent) {
        this.tagsProvider.commandStarted(commandStartedEvent);
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        this.timeCommand((CommandEvent)event, event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    public void commandFailed(CommandFailedEvent event) {
        this.timeCommand((CommandEvent)event, event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    private void timeCommand(CommandEvent event, long elapsedTimeInNanoseconds) {
        ((Timer.Builder)Timer.builder("mongodb.driver.commands").description("Timer of mongodb commands").tags((Iterable)this.tagsProvider.commandTags(event))).register(this.registry).record(elapsedTimeInNanoseconds, TimeUnit.NANOSECONDS);
    }
}

