/*
 * Decompiled with CFR 0.152.
 */
package karate.io.micrometer.core.instrument.cumulative;

import java.util.Arrays;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import karate.io.micrometer.core.instrument.AbstractDistributionSummary;
import karate.io.micrometer.core.instrument.Clock;
import karate.io.micrometer.core.instrument.Measurement;
import karate.io.micrometer.core.instrument.Meter;
import karate.io.micrometer.core.instrument.Statistic;
import karate.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import karate.io.micrometer.core.instrument.distribution.Histogram;
import karate.io.micrometer.core.instrument.distribution.TimeWindowMax;

public class CumulativeDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final TimeWindowMax max;

    @Deprecated
    public CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        this(id, clock, distributionStatisticConfig, scale, false);
    }

    public CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        this(id, clock, distributionStatisticConfig, scale, AbstractDistributionSummary.defaultHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles));
    }

    protected CumulativeDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, Histogram histogram) {
        super(id, scale, histogram);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.total.add(amount);
        this.max.record(amount);
    }

    @Override
    public long count() {
        return this.count.longValue();
    }

    @Override
    public double totalAmount() {
        return this.total.sum();
    }

    @Override
    public double max() {
        return this.max.poll();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL), new Measurement(this::max, Statistic.MAX));
    }
}

