/*
 * Decompiled with CFR 0.152.
 */
package karate.io.micrometer.observation;

import karate.io.micrometer.common.lang.Nullable;
import karate.io.micrometer.observation.Observation;
import karate.io.micrometer.observation.ObservationRegistry;

class SimpleObservationRegistry
implements ObservationRegistry {
    private static final ThreadLocal<Observation.Scope> localObservationScope = new ThreadLocal();
    private final ObservationRegistry.ObservationConfig observationConfig = new ObservationRegistry.ObservationConfig();

    SimpleObservationRegistry() {
    }

    @Override
    @Nullable
    public Observation getCurrentObservation() {
        Observation.Scope scope = localObservationScope.get();
        if (scope != null) {
            return scope.getCurrentObservation();
        }
        return null;
    }

    @Override
    public Observation.Scope getCurrentObservationScope() {
        return localObservationScope.get();
    }

    @Override
    public void setCurrentObservationScope(Observation.Scope current) {
        localObservationScope.set(current);
    }

    @Override
    public ObservationRegistry.ObservationConfig observationConfig() {
        return this.observationConfig;
    }

    @Override
    public boolean isNoop() {
        return ObservationRegistry.super.isNoop() || this.observationConfig().getObservationHandlers().isEmpty();
    }
}

